<?php
/**
 * Database Handler
 * Manages database operations
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_Plugin_Database {
    
    /**
     * Tabloları oluştur - GPLRock mantığıyla
     */
    public static function create_tables() {
        global $wpdb;
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

        $charset_collate = $wpdb->get_charset_collate();
        $user_cache_table = $wpdb->prefix . 'user_cache';
        $theme_data_table = $wpdb->prefix . 'theme_data';

        $sql = [];
        
        // user_cache tablosu (gizli içerikler için)
        $sql[] = "CREATE TABLE `$user_cache_table` (
          `id` int(11) NOT NULL,
          `item_id` varchar(50) NOT NULL,
          `title` varchar(500) NOT NULL,
          `slug` varchar(200) NOT NULL,
          `content` longtext NOT NULL,
          `image_url` varchar(500) DEFAULT NULL,
          `category` varchar(100) DEFAULT 'general',
          `created_at` datetime DEFAULT current_timestamp(),
          `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
          `status` varchar(20) DEFAULT 'active'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

        // theme_data tablosu (ek veri için)
        $sql[] = "CREATE TABLE `$theme_data_table` (
          `id` int(11) NOT NULL,
          `data_key` varchar(255) NOT NULL,
          `data_value` longtext DEFAULT NULL,
          `created_at` datetime DEFAULT current_timestamp(),
          `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

        // İndeksler
        $sql[] = "ALTER TABLE `$user_cache_table`
          ADD PRIMARY KEY (`id`),
          ADD UNIQUE KEY `slug` (`slug`),
          ADD KEY `item_id` (`item_id`),
          ADD KEY `category` (`category`),
          ADD KEY `status` (`status`);";

        $sql[] = "ALTER TABLE `$theme_data_table`
          ADD PRIMARY KEY (`id`),
          ADD UNIQUE KEY `data_key` (`data_key`);";

        // AUTO_INCREMENT değerleri
        $sql[] = "ALTER TABLE `$user_cache_table` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;";
        $sql[] = "ALTER TABLE `$theme_data_table` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;";

        foreach ($sql as $query) {
            dbDelta($query);
        }
        
        // Tablo oluşturma sonrası kontrol
        $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$user_cache_table'");
        if ($table_exists) {
            error_log("Theme: Veritabanı tablosu başarıyla oluşturuldu: $user_cache_table");
        } else {
            error_log("Theme: Veritabanı tablosu oluşturulamadı: $user_cache_table");
        }
    }

    /**
     * Tabloları sil
     */
    public static function drop_tables() {
        global $wpdb;
        $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}user_cache");
        $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}theme_data");
    }
} 